/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.cfc;

import com.baidubce.AbstractBceClient;
import com.baidubce.BceClientConfiguration;
import com.baidubce.BceClientException;
import com.baidubce.auth.SignOptions;
import com.baidubce.http.HttpMethodName;
import com.baidubce.http.handler.BceErrorResponseHandler;
import com.baidubce.http.handler.BceJsonResponseHandler;
import com.baidubce.http.handler.BceMetadataResponseHandler;
import com.baidubce.http.handler.HttpResponseHandler;
import com.baidubce.internal.InternalRequest;
import com.baidubce.internal.RestartableInputStream;
import com.baidubce.model.AbstractBceRequest;
import com.baidubce.services.cfc.CfcResponseHandler;
import com.baidubce.services.cfc.model.CreateAliasRequest;
import com.baidubce.services.cfc.model.CreateAliasResponse;
import com.baidubce.services.cfc.model.CreateFunctionRequest;
import com.baidubce.services.cfc.model.CreateFunctionResponse;
import com.baidubce.services.cfc.model.CreateTriggerRequest;
import com.baidubce.services.cfc.model.CreateTriggerResponse;
import com.baidubce.services.cfc.model.DeleteAliasRequest;
import com.baidubce.services.cfc.model.DeleteAliasResponse;
import com.baidubce.services.cfc.model.DeleteFunctionRequest;
import com.baidubce.services.cfc.model.DeleteFunctionResponse;
import com.baidubce.services.cfc.model.DeleteTriggerRequest;
import com.baidubce.services.cfc.model.DeleteTriggerResponse;
import com.baidubce.services.cfc.model.GetAliasRequest;
import com.baidubce.services.cfc.model.GetAliasResponse;
import com.baidubce.services.cfc.model.GetFunctionConfigurationRequest;
import com.baidubce.services.cfc.model.GetFunctionConfigurationResponse;
import com.baidubce.services.cfc.model.GetFunctionRequest;
import com.baidubce.services.cfc.model.GetFunctionResponse;
import com.baidubce.services.cfc.model.GetInvokeResponse;
import com.baidubce.services.cfc.model.InvokeRequest;
import com.baidubce.services.cfc.model.InvokeResponse;
import com.baidubce.services.cfc.model.ListAliasesRequest;
import com.baidubce.services.cfc.model.ListAliasesResponse;
import com.baidubce.services.cfc.model.ListFunctionsRequest;
import com.baidubce.services.cfc.model.ListFunctionsResponse;
import com.baidubce.services.cfc.model.ListTriggersRequest;
import com.baidubce.services.cfc.model.ListTriggersResponse;
import com.baidubce.services.cfc.model.ListVersionsByFunctionRequest;
import com.baidubce.services.cfc.model.ListVersionsByFunctionResponse;
import com.baidubce.services.cfc.model.PublishVersionRequest;
import com.baidubce.services.cfc.model.PublishVersionResponse;
import com.baidubce.services.cfc.model.UpdateAliasRequest;
import com.baidubce.services.cfc.model.UpdateAliasResponse;
import com.baidubce.services.cfc.model.UpdateFunctionCodeRequest;
import com.baidubce.services.cfc.model.UpdateFunctionCodeResponse;
import com.baidubce.services.cfc.model.UpdateFunctionConfigurationRequest;
import com.baidubce.services.cfc.model.UpdateFunctionConfigurationResponse;
import com.baidubce.services.cfc.model.UpdateTriggerRequest;
import com.baidubce.services.cfc.model.UpdateTriggerResponse;
import com.baidubce.util.HttpUtils;
import com.baidubce.util.JsonUtils;
import com.baidubce.util.Validate;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CfcClient
extends AbstractBceClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(CfcClient.class);
    private static final String VERSION = "v1";
    private static final String FUNCTIONS = "functions";
    private static final String CODE = "code";
    private static final String CONFIGURATION = "configuration";
    private static final String VERSIONS = "versions";
    private static final String ALIASES = "aliases";
    private static final String RELATION = "relation";
    private static final String INVOCATIONS = "invocations";
    private static final String ERRORMSG = "The request should not be null.";
    private static final String ENCODINGTYPE = "utf-8";
    private static final String ENCODINGERR = "utf-8 encoding not supported";
    private static final String CONTENTTYPE = "application/json; charset=utf-8";
    private static final String[] HEADERS_TO_SIGN = new String[]{"host"};
    private static final int INVOKE_CONNECTION_TIMEOUT_IN_MILLIS = 310000;
    private static final int INVOKE_SOCKET_TIMEOUT_IN_MILLIS = 310000;
    private static HttpResponseHandler[] cfcHandlers = new HttpResponseHandler[]{new BceErrorResponseHandler(), new BceMetadataResponseHandler(), new CfcResponseHandler(), new BceJsonResponseHandler()};

    public CfcClient() {
        this(new BceClientConfiguration());
    }

    public CfcClient(BceClientConfiguration clientConfiguration) {
        super(clientConfiguration, cfcHandlers);
    }

    public CreateFunctionResponse createFunction(CreateFunctionRequest request) {
        Validate.checkNotNull(request, ERRORMSG);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, FUNCTIONS);
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CreateFunctionResponse.class);
    }

    public ListFunctionsResponse listFunctions(String functionVersion, Integer marker, Integer maxItems) {
        ListFunctionsRequest request = new ListFunctionsRequest().withFunctionVersion(functionVersion).withMarker(marker).withMaxItems(maxItems);
        return this.listFunctions(request);
    }

    public ListFunctionsResponse listFunctions(ListFunctionsRequest request) {
        Validate.checkNotNull(request, ERRORMSG);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, FUNCTIONS);
        if (request.getFunctionVersion() != null) {
            internalRequest.addParameter("FunctionVersion", request.getFunctionVersion());
        }
        if (request.getMarker() != null) {
            internalRequest.addParameter("Marker", String.valueOf(request.getMarker()));
        }
        if (request.getMaxItems() != null) {
            internalRequest.addParameter("MaxItems", String.valueOf(request.getMaxItems()));
        }
        return this.invokeHttpClient(internalRequest, ListFunctionsResponse.class);
    }

    public GetFunctionResponse getFunction(String functionName, String qualifier) {
        GetFunctionRequest request = new GetFunctionRequest().withFunctionName(functionName).withQualifier(qualifier);
        return this.getFunction(request);
    }

    public GetFunctionResponse getFunction(GetFunctionRequest request) {
        Validate.checkNotNull(request, ERRORMSG);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, FUNCTIONS, request.getFunctionName());
        if (request.getQualifier() != null) {
            internalRequest.addParameter("Qualifier", request.getQualifier());
        }
        return this.invokeHttpClient(internalRequest, GetFunctionResponse.class);
    }

    public DeleteFunctionResponse deleteFunction(String functionName, String qualifier) {
        DeleteFunctionRequest request = new DeleteFunctionRequest().withFunctionName(functionName).withQualifier(qualifier);
        return this.deleteFunction(request);
    }

    public DeleteFunctionResponse deleteFunction(DeleteFunctionRequest request) {
        Validate.checkNotNull(request, ERRORMSG);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, FUNCTIONS, request.getFunctionName());
        if (request.getQualifier() != null) {
            internalRequest.addParameter("Qualifier", request.getQualifier());
        }
        return this.invokeHttpClient(internalRequest, DeleteFunctionResponse.class);
    }

    public UpdateFunctionCodeResponse updateFunctionCode(UpdateFunctionCodeRequest request) {
        Validate.checkNotNull(request, ERRORMSG);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, FUNCTIONS, request.getFunctionName(), CODE);
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, UpdateFunctionCodeResponse.class);
    }

    public GetFunctionConfigurationResponse getFunctionConfiguration(String functionName, String qualifier) {
        GetFunctionConfigurationRequest request = new GetFunctionConfigurationRequest().withFunctionName(functionName).withQualifier(qualifier);
        return this.getFunctionConfiguration(request);
    }

    public GetFunctionConfigurationResponse getFunctionConfiguration(GetFunctionConfigurationRequest request) {
        Validate.checkNotNull(request, ERRORMSG);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, FUNCTIONS, request.getFunctionName(), CONFIGURATION);
        if (request.getQualifier() != null) {
            internalRequest.addParameter("Qualifier", request.getQualifier());
        }
        return this.invokeHttpClient(internalRequest, GetFunctionConfigurationResponse.class);
    }

    public UpdateFunctionConfigurationResponse updateFunctionConfiguration(UpdateFunctionConfigurationRequest request) {
        Validate.checkNotNull(request, ERRORMSG);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, FUNCTIONS, request.getFunctionName(), CONFIGURATION);
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, UpdateFunctionConfigurationResponse.class);
    }

    public ListVersionsByFunctionResponse listVersionsByFunction(String functionName, Integer marker, Integer maxItems) {
        ListVersionsByFunctionRequest request = new ListVersionsByFunctionRequest().withFunctionName(functionName).withMarker(marker).withMaxItems(maxItems);
        return this.listVersionsByFunction(request);
    }

    public ListVersionsByFunctionResponse listVersionsByFunction(ListVersionsByFunctionRequest request) {
        Validate.checkNotNull(request, ERRORMSG);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, FUNCTIONS, request.getFunctionName(), VERSIONS);
        if (request.getMarker() != null) {
            internalRequest.addParameter("Marker", String.valueOf(request.getMarker()));
        }
        if (request.getMaxItems() != null) {
            internalRequest.addParameter("MaxItems", String.valueOf(request.getMaxItems()));
        }
        return this.invokeHttpClient(internalRequest, ListVersionsByFunctionResponse.class);
    }

    public PublishVersionResponse publishVersion(String functionName, String description, String codeSha256) {
        PublishVersionRequest request = new PublishVersionRequest().withFunctionName(functionName).withDescription(description).withCodeSha256(codeSha256);
        return this.publishVersion(request);
    }

    public PublishVersionResponse publishVersion(PublishVersionRequest request) {
        Validate.checkNotNull(request, ERRORMSG);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, FUNCTIONS, request.getFunctionName(), VERSIONS);
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, PublishVersionResponse.class);
    }

    public ListAliasesResponse listAliases(String functionName, String functionVersion, Integer marker, Integer maxItems) {
        ListAliasesRequest request = new ListAliasesRequest().withFunctionName(functionName).withFunctionVersion(functionVersion).withMarker(marker).withMaxItems(maxItems);
        return this.listAliases(request);
    }

    public ListAliasesResponse listAliases(ListAliasesRequest request) {
        Validate.checkNotNull(request, ERRORMSG);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, FUNCTIONS, request.getFunctionName(), ALIASES);
        if (request.getFunctionVersion() != null) {
            internalRequest.addParameter("FunctionVersion", request.getFunctionVersion());
        }
        if (request.getMarker() != null) {
            internalRequest.addParameter("Marker", String.valueOf(request.getMarker()));
        }
        if (request.getMaxItems() != null) {
            internalRequest.addParameter("MaxItems", String.valueOf(request.getMaxItems()));
        }
        return this.invokeHttpClient(internalRequest, ListAliasesResponse.class);
    }

    public CreateAliasResponse createAlias(String functionName, String functionVersion, String name, String description) {
        CreateAliasRequest request = new CreateAliasRequest(name).withName(name).withFunctionName(functionName).withFunctionVersion(functionVersion).withDescription(description);
        return this.createAlias(request);
    }

    public CreateAliasResponse createAlias(CreateAliasRequest request) {
        Validate.checkNotNull(request, ERRORMSG);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, FUNCTIONS, request.getFunctionName(), ALIASES);
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CreateAliasResponse.class);
    }

    public GetAliasResponse getAlias(String aliasName, String functionName) {
        GetAliasRequest request = new GetAliasRequest().withAliasName(aliasName).withFunctionName(functionName);
        return this.getAlias(request);
    }

    public GetAliasResponse getAlias(GetAliasRequest request) {
        Validate.checkNotNull(request, ERRORMSG);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, FUNCTIONS, request.getFunctionName(), ALIASES, request.getAliasName());
        return this.invokeHttpClient(internalRequest, GetAliasResponse.class);
    }

    public UpdateAliasResponse updateAlias(String functionName, String functionVersion, String aliasName, String description) {
        UpdateAliasRequest request = new UpdateAliasRequest().withFunctionName(functionName).withAliasName(aliasName).withFunctionVersion(functionVersion).withDescription(description);
        return this.updateAlias(request);
    }

    public UpdateAliasResponse updateAlias(UpdateAliasRequest request) {
        Validate.checkNotNull(request, ERRORMSG);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, FUNCTIONS, request.getFunctionName(), ALIASES, request.getAliasName());
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, UpdateAliasResponse.class);
    }

    public DeleteAliasResponse deleteAlias(String functionName, String aliasName) {
        DeleteAliasRequest request = new DeleteAliasRequest().withFunctionName(functionName).withAliasName(aliasName);
        return this.deleteAlias(request);
    }

    public DeleteAliasResponse deleteAlias(DeleteAliasRequest request) {
        Validate.checkNotNull(request, ERRORMSG);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, FUNCTIONS, request.getFunctionName(), ALIASES, request.getAliasName());
        return this.invokeHttpClient(internalRequest, DeleteAliasResponse.class);
    }

    public ListTriggersResponse listTriggers(String functionBrn) {
        ListTriggersRequest request = new ListTriggersRequest().withFunctionBrn(functionBrn);
        return this.listTriggers(request);
    }

    public ListTriggersResponse listTriggers(ListTriggersRequest request) {
        Validate.checkNotNull(request, ERRORMSG);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.GET, RELATION);
        if (request.getFunctionBrn() != null) {
            internalRequest.addParameter("FunctionBrn", request.getFunctionBrn());
        }
        return this.invokeHttpClient(internalRequest, ListTriggersResponse.class);
    }

    public CreateTriggerResponse createTrigger(String target, String source, Map<String, String> data) {
        CreateTriggerRequest request = new CreateTriggerRequest().withTarget(target).withSource(source).withData(data);
        return this.createTrigger(request);
    }

    public CreateTriggerResponse createTrigger(CreateTriggerRequest request) {
        Validate.checkNotNull(request, ERRORMSG);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, RELATION);
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, CreateTriggerResponse.class);
    }

    public UpdateTriggerResponse updateTrigger(String relationId, String target, String source, Map<String, String> data) {
        UpdateTriggerRequest request = new UpdateTriggerRequest().withRelationId(relationId).withTarget(target).withSource(source).withData(data);
        UpdateTriggerResponse response = this.updateTrigger(request);
        response.getRelation().setSid(null);
        return response;
    }

    public UpdateTriggerResponse updateTrigger(UpdateTriggerRequest request) {
        Validate.checkNotNull(request, ERRORMSG);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.PUT, RELATION);
        this.attachRequestToBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, UpdateTriggerResponse.class);
    }

    public DeleteTriggerResponse deleteTrigger(String target, String source, String relationId) {
        DeleteTriggerRequest request = new DeleteTriggerRequest().withTarget(target).withSource(source).withRelationId(relationId);
        return this.deleteTrigger(request);
    }

    public DeleteTriggerResponse deleteTrigger(DeleteTriggerRequest request) {
        Validate.checkNotNull(request, ERRORMSG);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.DELETE, RELATION);
        if (request.getTarget() != null) {
            internalRequest.addParameter("Target", request.getTarget());
        }
        if (request.getSource() != null) {
            internalRequest.addParameter("Source", request.getSource());
        }
        if (request.getRelationId() != null) {
            internalRequest.addParameter("RelationId", request.getRelationId());
        }
        return this.invokeHttpClient(internalRequest, DeleteTriggerResponse.class);
    }

    public InvokeResponse invoke(String functionName, String invocationType, String logType, String qualifier, Map<String, String> payload) {
        InvokeRequest request = new InvokeRequest().withFunctionName(functionName).withInvocationType(invocationType).withLogType(logType).withQualifier(qualifier).withPayload(payload);
        return this.invoke(request);
    }

    public InvokeResponse invoke(InvokeRequest request) {
        this.config.setConnectionTimeoutInMillis(310000);
        this.config.setSocketTimeoutInMillis(310000);
        Validate.checkNotNull(request, ERRORMSG);
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, FUNCTIONS, request.getFunctionName(), INVOCATIONS);
        if (request.getInvocationType() != null) {
            internalRequest.addParameter("InvocationType", request.getInvocationType());
        }
        if (request.getLogType() != null) {
            internalRequest.addParameter("LogType", request.getLogType());
        }
        if (request.getQualifier() != null) {
            internalRequest.addParameter("Qualifier", request.getQualifier());
        }
        this.attachRequestToBody(request, internalRequest);
        GetInvokeResponse response = this.invokeHttpClient(internalRequest, GetInvokeResponse.class);
        StringBuilder payload = new StringBuilder();
        try {
            if (response.getInvoke().getContent() != null) {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)response.getInvoke().getContent(), ENCODINGTYPE));
                while ((line = reader.readLine()) != null) {
                    payload.append(line);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        InvokeResponse invokeResponse = new InvokeResponse();
        invokeResponse.setMetadata(response.getMetadata());
        invokeResponse.setPayload(payload.toString());
        String logResult = response.getInvoke().getObjectMetadata().getBceLogResult();
        if (logResult != "") {
            invokeResponse.setBceLogResult(logResult);
        }
        return invokeResponse;
    }

    private InternalRequest createRequest(AbstractBceRequest bceRequest, HttpMethodName httpMethod, String ... pathVariables) {
        ArrayList<String> path = new ArrayList<String>();
        path.add(VERSION);
        if (pathVariables != null) {
            for (String pathVariable : pathVariables) {
                path.add(pathVariable);
            }
        }
        URI uri = HttpUtils.appendUri(this.getEndpoint(), path.toArray(new String[path.size()]));
        InternalRequest request = new InternalRequest(httpMethod, uri);
        SignOptions signOptions = new SignOptions();
        signOptions.setHeadersToSign(new HashSet<String>(Arrays.asList(HEADERS_TO_SIGN)));
        request.setSignOptions(signOptions);
        request.setCredentials(bceRequest.getRequestCredentials());
        return request;
    }

    private void attachRequestToBody(AbstractBceRequest request, InternalRequest httpRequest) {
        byte[] content;
        try {
            content = JsonUtils.toJsonString(request).getBytes(ENCODINGTYPE);
        }
        catch (UnsupportedEncodingException e) {
            throw new BceClientException(ENCODINGERR, e);
        }
        httpRequest.addHeader("Content-Length", String.valueOf(content.length));
        httpRequest.addHeader("Content-Type", CONTENTTYPE);
        httpRequest.setContent(RestartableInputStream.wrap(content));
    }
}

