/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.ruleengine;

import com.baidubce.BceClientConfiguration;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.http.HttpMethodName;
import com.baidubce.internal.InternalRequest;
import com.baidubce.services.ruleengine.AbstractRuleEngineBceClient;
import com.baidubce.services.ruleengine.model.FeedMessageRequest;
import com.baidubce.services.ruleengine.model.FeedMessageResponse;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleEngineDataClient
extends AbstractRuleEngineBceClient {
    private static Logger logger = LoggerFactory.getLogger(RuleEngineDataClient.class);
    private static final String RULE_UUID_KEY = "ruleid";
    private static final String RULE_DATA = "ruledata";
    private static final String FEED = "feed";
    private static final String ENDPOINT = "iotredata.gz.baidubce.com";

    public RuleEngineDataClient(BceClientConfiguration configuration) {
        super(configuration.getEndpoint() == null ? configuration.withEndpoint(ENDPOINT) : configuration, HANDLERS);
    }

    public RuleEngineDataClient(String accessKey, String secretKey) {
        this(new BceClientConfiguration().withCredentials(new DefaultBceCredentials(accessKey, secretKey)).withEndpoint(ENDPOINT));
    }

    public FeedMessageResponse feed(String uuid, List<String> msgs) {
        return this.feed(uuid, new FeedMessageRequest().withSimplePayloads(msgs));
    }

    public FeedMessageResponse feed(String uuid, FeedMessageRequest request) {
        return this.feed(uuid, request, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FeedMessageResponse feed(String uuid, FeedMessageRequest request, boolean isGzip) {
        Preconditions.checkNotNull((Object)uuid, (Object)"uuid should not be null.");
        Preconditions.checkNotNull((Object)request, (Object)"request should not be null.");
        InternalRequest internalRequest = this.createRequest(request, HttpMethodName.POST, RULE_DATA, FEED);
        internalRequest.addParameter(RULE_UUID_KEY, uuid);
        if (isGzip) {
            byte[] bytes = this.toGzipBytes(request);
            this.fillInHeadAndBodyForGzip(internalRequest, bytes);
            FeedMessageResponse response = null;
            try {
                response = this.invokeHttpClient(internalRequest, FeedMessageResponse.class);
            }
            finally {
                try {
                    internalRequest.getContent().close();
                }
                catch (IOException e) {
                    logger.error("Request content close failed.", (Throwable)e);
                }
            }
            return response;
        }
        this.fillInHeadAndBody(request, internalRequest);
        return this.invokeHttpClient(internalRequest, FeedMessageResponse.class);
    }
}

