/*
 * Decompiled with CFR 0.152.
 */
package com.baidubce.services.tablestoragehbaseclient.adaptor;

import com.baidubce.services.tablestorage.model.CompressType;
import com.baidubce.services.tablestorage.model.TableStorageCell;
import com.baidubce.services.tablestorage.model.TableStorageResult;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.util.Bytes;

public class TablestorageConvertor {
    public static Compression.Algorithm toCompressionAlgorithm(CompressType type) {
        if (type == CompressType.NONE) {
            return Compression.Algorithm.NONE;
        }
        if (type == CompressType.SNAPPY_ALL) {
            return Compression.Algorithm.SNAPPY;
        }
        return Compression.Algorithm.valueOf((String)type.name());
    }

    public static CompressType toCompressionType(Compression.Algorithm algorithm) {
        if (algorithm == Compression.Algorithm.NONE) {
            return CompressType.NONE;
        }
        if (algorithm == Compression.Algorithm.SNAPPY) {
            return CompressType.SNAPPY_ALL;
        }
        throw new UnsupportedOperationException("Only support SNAPPY compression algorithm");
    }

    public static Result toHBaseResult(TableStorageResult tableStorageResult) {
        if (tableStorageResult == null) {
            return Result.create((Cell[])new Cell[0]);
        }
        List<TableStorageCell> tableStorageCells = tableStorageResult.getCells();
        ArrayList<Cell> cells = new ArrayList<Cell>(tableStorageResult.getCells().size());
        for (TableStorageCell cell : tableStorageCells) {
            Cell hbaseCell = CellUtil.createCell((byte[])tableStorageResult.getRowkey().getBytes(), (byte[])"cf0".getBytes(), (byte[])cell.getColumn().getBytes(), (long)(cell.getTimestamp() == 0L ? Long.MAX_VALUE : cell.getTimestamp()), (byte)KeyValue.Type.Put.getCode(), (byte[])cell.getValue().getBytes());
            cells.add(hbaseCell);
        }
        return Result.create(cells);
    }

    public static Result[] toBatchGetHBaseResults(List<Get> gets, List<TableStorageResult> tableStorageResults) {
        Result[] results = new Result[gets.size()];
        int index = 0;
        int getsIndex = 0;
        for (TableStorageResult tableStorageResult : tableStorageResults) {
            while (Bytes.compareTo((byte[])gets.get(getsIndex++).getRow(), (byte[])tableStorageResult.getRowkey().getBytes()) != 0) {
                results[index++] = TablestorageConvertor.toHBaseResult(null);
            }
            results[index++] = TablestorageConvertor.toHBaseResult(tableStorageResult);
        }
        while (index < results.length) {
            results[index++] = TablestorageConvertor.toHBaseResult(null);
        }
        return results;
    }
}

