/*
 * Decompiled with CFR 0.152.
 */
package com.baomidou.dynamic.datasource.creator;

import cn.beecp.BeeDataSource;
import cn.beecp.BeeDataSourceConfig;
import com.baomidou.dynamic.datasource.creator.DataSourceCreator;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.DataSourceProperty;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.beecp.BeeCpConfig;
import com.baomidou.dynamic.datasource.spring.boot.autoconfigure.beecp.BeeCpUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class BeeCpDataSourceCreator
implements DataSourceCreator {
    private static final Logger log = LoggerFactory.getLogger(BeeCpDataSourceCreator.class);
    private static Boolean beeCpExists = false;
    private static Method copyToMethod = null;
    private BeeCpConfig gConfig;

    @Override
    public DataSource createDataSource(DataSourceProperty dataSourceProperty) {
        BeeDataSourceConfig config = BeeCpUtils.createConfig(this.gConfig, dataSourceProperty.getBeecp());
        config.setUsername(dataSourceProperty.getUsername());
        config.setPassword(dataSourceProperty.getPassword());
        config.setJdbcUrl(dataSourceProperty.getUrl());
        config.setPoolName(dataSourceProperty.getPoolName());
        String driverClassName = dataSourceProperty.getDriverClassName();
        if (!StringUtils.isEmpty((Object)driverClassName)) {
            config.setDriverClassName(driverClassName);
        }
        if (!dataSourceProperty.getLazy().booleanValue()) {
            return new BeeDataSource(config);
        }
        BeeDataSource beeDataSource = new BeeDataSource();
        try {
            copyToMethod.invoke((Object)config, beeDataSource);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        return beeDataSource;
    }

    @Override
    public boolean support(DataSourceProperty dataSourceProperty) {
        Class<? extends DataSource> type = dataSourceProperty.getType();
        return type == null && beeCpExists != false || type != null && "cn.beecp.BeeDataSource".equals(type.getName());
    }

    public BeeCpConfig getGConfig() {
        return this.gConfig;
    }

    public void setGConfig(BeeCpConfig gConfig) {
        this.gConfig = gConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BeeCpDataSourceCreator)) {
            return false;
        }
        BeeCpDataSourceCreator other = (BeeCpDataSourceCreator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BeeCpConfig this$gConfig = this.getGConfig();
        BeeCpConfig other$gConfig = other.getGConfig();
        return !(this$gConfig == null ? other$gConfig != null : !((Object)this$gConfig).equals(other$gConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BeeCpDataSourceCreator;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BeeCpConfig $gConfig = this.getGConfig();
        result = result * 59 + ($gConfig == null ? 43 : ((Object)$gConfig).hashCode());
        return result;
    }

    public String toString() {
        return "BeeCpDataSourceCreator(gConfig=" + this.getGConfig() + ")";
    }

    public BeeCpDataSourceCreator(BeeCpConfig gConfig) {
        this.gConfig = gConfig;
    }

    static {
        try {
            Class.forName("cn.beecp.BeeDataSource");
            beeCpExists = true;
            copyToMethod = BeeDataSourceConfig.class.getDeclaredMethod("copyTo", BeeDataSourceConfig.class);
            copyToMethod.setAccessible(true);
        }
        catch (ClassNotFoundException | NoSuchMethodException reflectiveOperationException) {
            // empty catch block
        }
    }
}

