/*
 * Decompiled with CFR 0.152.
 */
package com.bocnet.common.security;

import com.bocnet.common.security.PKCS7Tool;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;

public class P7Verify {
    public static void main(String[] args) throws GeneralSecurityException, IOException {
        if (args.length < 2 || args.length > 5) {
            System.out.println("Usage: \nP7Verify rootcertfile signaturefile [inputfile] [dn]\n\trootcertfile support .cer or .p7b file.");
            System.exit(-1);
        }
        if (args[args.length - 2].startsWith("-SHA")) {
            PKCS7Tool.setDigestAlgorithm(args[args.length - 2].substring(1));
            PKCS7Tool.setSigningAlgorithm(String.valueOf(args[args.length - 2].substring(1)) + "withRSA");
            args[args.length - 2] = null;
        }
        if ("-debug".equals(args[args.length - 1])) {
            PKCS7Tool.setDebug(true);
            args[args.length - 1] = null;
        }
        InputStream in = System.in;
        FileInputStream signin = null;
        try {
            PKCS7Tool tool = PKCS7Tool.getVerifier(args[0]);
            signin = new FileInputStream(args[1]);
            String signature = new String(PKCS7Tool.readData(signin));
            if (args.length > 2 && args[2] != null) {
                in = new FileInputStream(args[2]);
            }
            byte[] data = PKCS7Tool.readData(in);
            String dn = null;
            if (args.length > 3 && args[3] != null) {
                dn = args[3];
            }
            tool.verify(signature, data, dn);
        }
        finally {
            if (in != null && System.in != in) {
                in.close();
            }
            if (signin != null) {
                signin.close();
            }
        }
        System.out.println("[VERIFY OK]");
    }
}

