/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.driver;

import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmdbArray;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbRef;
import dm.jdbc.driver.DmdbSQLXML;
import dm.jdbc.internal.convert.DB2J;
import dm.jdbc.internal.desc.Column;
import dm.jdbc.internal.desc.ComplexTypeData;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

public class DmdbArrayDataResultSet
implements ResultSet {
    private DmdbArray m_array = null;
    private long m_startIndex = 1L;
    private int m_rowCount = 0;
    private int m_curRowNum = (int)(this.m_startIndex - 1L);
    private boolean m_isClosed = false;
    private boolean m_wasPrivColNull = false;
    private int m_direction = 1000;
    private int m_fetchSize = -1;
    private DmdbConnection m_conn = null;

    public DmdbArrayDataResultSet(DmdbArray arr) {
        this.m_array = arr;
        this.m_rowCount = this.m_array.m_arrData.length;
        this.m_startIndex = 1L;
        this.m_curRowNum = (int)(this.m_startIndex - 1L);
        this.m_conn = this.m_array.m_arrDesc.m_conn;
    }

    public DmdbArrayDataResultSet(DmdbArray arr, long index, int count) {
        this(arr);
        this.m_startIndex = index;
        this.m_rowCount = this.m_rowCount < count ? this.m_rowCount : count;
        this.m_curRowNum = (int)(this.m_startIndex - 1L);
    }

    private void checkClose() throws SQLException {
        if (this.m_isClosed) {
            DBError.ECJDBC_RESULTSET_CLOSED.throwz(new Object[0]);
        }
    }

    private void checkCurrentRow() throws SQLException {
        this.checkClose();
        if ((long)this.m_curRowNum < this.m_startIndex && this.m_curRowNum > this.m_rowCount) {
            DBError.ECJDBC_CURSOR_NOT_IN_RESULTSET.throwz(new Object[0]);
        }
    }

    private boolean checkIsNull(ComplexTypeData typeData) {
        this.m_wasPrivColNull = typeData.m_dataBuf == null && typeData.m_dumyData == null;
        return this.m_wasPrivColNull;
    }

    private void release() {
        this.m_array = null;
        this.m_rowCount = 0;
        this.m_startIndex = 1L;
        this.m_isClosed = true;
    }

    private void checkUpdatable() throws SQLException {
        DBError.ECJDBC_RESULTSET_IS_READ_ONLY.throwz(new Object[0]);
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClose();
        if (this.m_rowCount > this.m_curRowNum) {
            ++this.m_curRowNum;
            return true;
        }
        return false;
    }

    @Override
    public void close() throws SQLException {
        if (this.m_isClosed) {
            return;
        }
        this.release();
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.m_wasPrivColNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof String) {
            return (String)typeData.m_dumyData;
        }
        Column desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return DB2J.toString(typeData.m_dataBuf, desc, this.m_conn);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return false;
        }
        if (typeData.m_dumyData instanceof Boolean) {
            return (Boolean)typeData.m_dumyData;
        }
        Column desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return DB2J.toBoolean(typeData.m_dataBuf, desc, this.m_conn);
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return 0;
        }
        if (typeData.m_dumyData instanceof Byte) {
            return (Byte)typeData.m_dumyData;
        }
        Column desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return DB2J.toByte(typeData.m_dataBuf, desc, this.m_conn);
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return 0;
        }
        if (typeData.m_dumyData instanceof Short) {
            return (Short)typeData.m_dumyData;
        }
        Column desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return DB2J.toShort(typeData.m_dataBuf, desc, this.m_conn);
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return 0;
        }
        if (typeData.m_dumyData instanceof Integer) {
            return (Integer)typeData.m_dumyData;
        }
        Column desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return DB2J.toInt(typeData.m_dataBuf, desc, this.m_conn);
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return 0L;
        }
        if (typeData.m_dumyData instanceof Long) {
            return (Long)typeData.m_dumyData;
        }
        Column desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return DB2J.toLong(typeData.m_dataBuf, desc, this.m_conn);
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return 0.0f;
        }
        if (typeData.m_dumyData instanceof Float) {
            return ((Float)typeData.m_dumyData).longValue();
        }
        Column desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return DB2J.toFloat(typeData.m_dataBuf, desc, this.m_conn);
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return 0.0;
        }
        if (typeData.m_dumyData instanceof Double) {
            return (Double)typeData.m_dumyData;
        }
        Column desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return DB2J.toDouble(typeData.m_dataBuf, desc, this.m_conn);
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        BigDecimal bg = this.getBigDecimal(columnIndex);
        if (bg == null) {
            return null;
        }
        return bg.setScale(scale, 4);
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof byte[]) {
            return (byte[])typeData.m_dumyData;
        }
        Column desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return DB2J.toBytes(typeData.m_dataBuf, desc, this.m_conn);
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Date) {
            return (Date)typeData.m_dumyData;
        }
        Column desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return DB2J.toDate(typeData.m_dataBuf, desc, this.m_conn, null);
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Time) {
            return (Time)typeData.m_dumyData;
        }
        Column desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return DB2J.toTime(typeData.m_dataBuf, desc, this.m_conn, null);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Timestamp) {
            return (Timestamp)typeData.m_dumyData;
        }
        Column desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return DB2J.toTimestamp(typeData.m_dataBuf, desc, this.m_conn, null);
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        Column desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return DB2J.toAsciiStream(typeData.m_dataBuf, desc, this.m_conn);
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        Column desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return DB2J.toUnicodeStream(typeData.m_dataBuf, desc, this.m_conn);
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        Column desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return DB2J.toBinaryStream(typeData.m_dataBuf, desc, this.m_conn);
    }

    @Override
    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    @Override
    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    @Override
    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    @Override
    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    @Override
    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    @Override
    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    @Override
    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    @Override
    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    @Override
    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    @Override
    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    @Override
    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    @Override
    public InputStream getAsciiStream(String columnName) throws SQLException {
        return this.getAsciiStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getUnicodeStream(String columnName) throws SQLException {
        return this.getUnicodeStream(this.findColumn(columnName));
    }

    @Override
    public InputStream getBinaryStream(String columnName) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnName));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public String getCursorName() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        return typeData.m_dumyData;
    }

    @Override
    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    @Override
    public int findColumn(String columnName) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return 0;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        Column desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return DB2J.toCharacterStream(typeData.m_dataBuf, desc, this.m_conn);
    }

    @Override
    public Reader getCharacterStream(String columnName) throws SQLException {
        return this.getCharacterStream(this.findColumn(columnName));
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, columnIndex, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof BigDecimal) {
            return (BigDecimal)typeData.m_dumyData;
        }
        Column desc = this.m_array.getDataDesc(this.m_curRowNum, columnIndex);
        return DB2J.toBigDecimal(typeData.m_dataBuf, desc, this.m_conn);
    }

    @Override
    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        return this.m_curRowNum + 1 <= 0;
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        return this.m_curRowNum + 1 > this.m_rowCount;
    }

    @Override
    public boolean isFirst() throws SQLException {
        return this.m_curRowNum + 1 == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        return this.m_curRowNum + 1 == this.m_rowCount;
    }

    @Override
    public void beforeFirst() throws SQLException {
        this.checkClose();
        if (this.m_rowCount <= 0) {
            return;
        }
        this.m_curRowNum = -1;
    }

    @Override
    public void afterLast() throws SQLException {
        this.checkClose();
        if (this.m_rowCount <= 0) {
            return;
        }
        this.m_curRowNum = this.m_rowCount;
    }

    @Override
    public boolean first() throws SQLException {
        this.checkClose();
        if (this.m_rowCount > 0) {
            this.m_curRowNum = 0;
            return true;
        }
        return false;
    }

    @Override
    public boolean last() throws SQLException {
        this.checkClose();
        if (this.m_rowCount > 0) {
            this.m_curRowNum = this.m_rowCount - 1;
            return true;
        }
        return false;
    }

    @Override
    public int getRow() throws SQLException {
        return this.m_curRowNum + 1;
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        this.checkClose();
        if (Math.abs(row) > this.m_rowCount || row == 0) {
            return false;
        }
        if (row < 0) {
            this.m_curRowNum = row + this.m_rowCount;
            return true;
        }
        this.m_curRowNum = row - 1;
        return true;
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        this.checkClose();
        if (rows == 0) {
            return !this.isBeforeFirst() && !this.isAfterLast();
        }
        int realRow = this.m_curRowNum + rows;
        if (realRow + 1 > this.m_rowCount || realRow + 1 < 1) {
            return false;
        }
        this.m_curRowNum = realRow;
        return true;
    }

    @Override
    public boolean previous() throws SQLException {
        this.checkClose();
        int realRow = this.m_curRowNum - 1;
        if (realRow < 0 || realRow >= this.m_rowCount) {
            return false;
        }
        this.m_curRowNum = realRow;
        return true;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.m_direction = direction;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return this.m_direction;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.m_fetchSize = rows;
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.m_fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        this.checkUpdatable();
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        this.checkUpdatable();
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        this.checkUpdatable();
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x2) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateByte(int columnIndex, byte x2) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateShort(int columnIndex, short x2) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateInt(int columnIndex, int x2) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateLong(int columnIndex, long x2) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateFloat(int columnIndex, float x2) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateDouble(int columnIndex, double x2) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x2) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateString(int columnIndex, String x2) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x2) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateDate(int columnIndex, Date x2) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateTime(int columnIndex, Time x2) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x2) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x2, int length) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x2, int length) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x2, int length) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateObject(int columnIndex, Object x2, int scale) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateObject(int columnIndex, Object x2) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateNull(String columnName) throws SQLException {
        this.updateNull(this.findColumn(columnName));
    }

    @Override
    public void updateBoolean(String columnName, boolean x2) throws SQLException {
        this.updateBoolean(this.findColumn(columnName), x2);
    }

    @Override
    public void updateByte(String columnName, byte x2) throws SQLException {
        this.updateByte(this.findColumn(columnName), x2);
    }

    @Override
    public void updateShort(String columnName, short x2) throws SQLException {
        this.updateShort(this.findColumn(columnName), x2);
    }

    @Override
    public void updateInt(String columnName, int x2) throws SQLException {
        this.updateInt(this.findColumn(columnName), x2);
    }

    @Override
    public void updateLong(String columnName, long x2) throws SQLException {
        this.updateLong(this.findColumn(columnName), x2);
    }

    @Override
    public void updateFloat(String columnName, float x2) throws SQLException {
        this.updateFloat(this.findColumn(columnName), x2);
    }

    @Override
    public void updateDouble(String columnName, double x2) throws SQLException {
        this.updateDouble(this.findColumn(columnName), x2);
    }

    @Override
    public void updateBigDecimal(String columnName, BigDecimal x2) throws SQLException {
        this.updateBigDecimal(this.findColumn(columnName), x2);
    }

    @Override
    public void updateString(String columnName, String x2) throws SQLException {
        this.updateString(this.findColumn(columnName), x2);
    }

    @Override
    public void updateBytes(String columnName, byte[] x2) throws SQLException {
        this.updateBytes(this.findColumn(columnName), x2);
    }

    @Override
    public void updateDate(String columnName, Date x2) throws SQLException {
        this.updateDate(this.findColumn(columnName), x2);
    }

    @Override
    public void updateTime(String columnName, Time x2) throws SQLException {
        this.updateTime(this.findColumn(columnName), x2);
    }

    @Override
    public void updateTimestamp(String columnName, Timestamp x2) throws SQLException {
        this.updateTimestamp(this.findColumn(columnName), x2);
    }

    @Override
    public void updateAsciiStream(String columnName, InputStream x2, int length) throws SQLException {
        this.updateAsciiStream(this.findColumn(columnName), x2, length);
    }

    @Override
    public void updateBinaryStream(String columnName, InputStream x2, int length) throws SQLException {
        this.updateBinaryStream(this.findColumn(columnName), x2, length);
    }

    @Override
    public void updateCharacterStream(String columnName, Reader reader, int length) throws SQLException {
        this.updateCharacterStream(this.findColumn(columnName), reader, length);
    }

    @Override
    public void updateObject(String columnName, Object x2, int scale) throws SQLException {
        this.updateObject(this.findColumn(columnName), x2, scale);
    }

    @Override
    public void updateObject(String columnName, Object x2) throws SQLException {
        this.updateObject(this.findColumn(columnName), x2);
    }

    @Override
    public void insertRow() throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateRow() throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void deleteRow() throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void refreshRow() throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public Statement getStatement() throws SQLException {
        this.checkUpdatable();
        return null;
    }

    @Override
    public Object getObject(int i2, Map<String, Class<?>> map) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public Ref getRef(int i2) throws SQLException {
        Object obj = this.getObject(i2);
        if (obj == null) {
            return null;
        }
        if (obj instanceof SQLData || obj instanceof Struct) {
            DmdbRef ref = new DmdbRef(obj);
            return ref;
        }
        DBError.ECJDBC_DATA_CONVERTION_ERROR.throwz(new Object[0]);
        return null;
    }

    @Override
    public Blob getBlob(int i2) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, i2, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Blob) {
            return (Blob)typeData.m_dumyData;
        }
        Column desc = this.m_array.getDataDesc(this.m_curRowNum, i2);
        return DB2J.toBlob(typeData.m_dataBuf, desc, this.m_conn);
    }

    @Override
    public Clob getClob(int i2) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, i2, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof Clob) {
            return (Clob)typeData.m_dumyData;
        }
        Column desc = this.m_array.getDataDesc(this.m_curRowNum, i2);
        return DB2J.toClob(typeData.m_dataBuf, desc, this.m_conn);
    }

    @Override
    public Array getArray(int i2) throws SQLException {
        this.checkCurrentRow();
        ComplexTypeData typeData = this.m_array.getData(this.m_curRowNum, i2, null);
        if (this.checkIsNull(typeData)) {
            return null;
        }
        if (typeData.m_dumyData instanceof DmdbArray) {
            return (Array)typeData.m_dumyData;
        }
        Column desc = this.m_array.getDataDesc(this.m_curRowNum, i2);
        return DB2J.toArray(typeData.m_dataBuf, desc, this.m_conn);
    }

    @Override
    public Object getObject(String colName, Map<String, Class<?>> map) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public Ref getRef(String colName) throws SQLException {
        return this.getRef(this.findColumn(colName));
    }

    @Override
    public Blob getBlob(String colName) throws SQLException {
        return this.getBlob(this.findColumn(colName));
    }

    @Override
    public Clob getClob(String colName) throws SQLException {
        return this.getClob(this.findColumn(colName));
    }

    @Override
    public Array getArray(String colName) throws SQLException {
        return this.getArray(this.findColumn(colName));
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        Date date = this.getDate(columnIndex);
        if (date == null) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTime(date);
        return new Date(cal.getTimeInMillis());
    }

    @Override
    public Date getDate(String columnName, Calendar cal) throws SQLException {
        return this.getDate(this.findColumn(columnName), cal);
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        Time time = this.getTime(columnIndex);
        if (time == null) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(time.getTime());
        return new Time(cal.getTimeInMillis());
    }

    @Override
    public Time getTime(String columnName, Calendar cal) throws SQLException {
        return this.getTime(this.findColumn(columnName), cal);
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        Timestamp timestamp = this.getTimestamp(columnIndex);
        if (timestamp == null) {
            return null;
        }
        if (cal == null) {
            cal = Calendar.getInstance();
        }
        cal.clear();
        cal.setTimeInMillis(timestamp.getTime());
        return new Timestamp(cal.getTimeInMillis());
    }

    @Override
    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName), cal);
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        if (str == null) {
            return null;
        }
        try {
            return new URL(str);
        }
        catch (Exception e2) {
            DBError.ECJDBC_DATA_CONVERTION_ERROR.throwException(e2);
            return null;
        }
    }

    @Override
    public URL getURL(String columnName) throws SQLException {
        return this.getURL(this.findColumn(columnName));
    }

    @Override
    public void updateRef(int columnIndex, Ref x2) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateRef(String columnName, Ref x2) throws SQLException {
        this.updateRef(this.findColumn(columnName), x2);
    }

    @Override
    public void updateBlob(int columnIndex, Blob x2) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateBlob(String columnName, Blob x2) throws SQLException {
        this.updateBlob(this.findColumn(columnName), x2);
    }

    @Override
    public void updateClob(int columnIndex, Clob x2) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateClob(String columnName, Clob x2) throws SQLException {
        this.updateClob(this.findColumn(columnName), x2);
    }

    @Override
    public void updateArray(int columnIndex, Array x2) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateArray(String columnName, Array x2) throws SQLException {
        this.updateArray(this.findColumn(columnName), x2);
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return iface.cast(this);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isInstance(this);
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public void updateRowId(int columnIndex, RowId x2) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateRowId(String columnLabel, RowId x2) throws SQLException {
        this.updateRowId(this.findColumn(columnLabel), x2);
    }

    @Override
    public int getHoldability() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return this.m_conn.resultSetHoldability;
    }

    @Override
    public boolean isClosed() throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return false;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        this.updateString(columnIndex, nString);
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        this.updateString(columnLabel, nString);
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        this.updateClob(columnIndex, (Clob)nClob);
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        this.updateClob(columnLabel, (Clob)nClob);
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        return (NClob)this.getClob(columnIndex);
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        return (NClob)this.getClob(columnLabel);
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        String str = this.getString(columnIndex);
        DmdbSQLXML sqlxml = new DmdbSQLXML();
        sqlxml.setString(str);
        return sqlxml;
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        return this.getSQLXML(this.findColumn(columnLabel));
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        this.checkUpdatable();
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        this.updateSQLXML(this.findColumn(columnLabel), xmlObject);
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        return this.getString(columnIndex);
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        return this.getString(columnLabel);
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        return this.getCharacterStream(columnIndex);
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        return this.getCharacterStream(columnLabel);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x2, long length) throws SQLException {
        this.updateCharacterStream(columnIndex, x2, length);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateCharacterStream(columnLabel, reader, length);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x2, long length) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x2, long length) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x2, long length) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x2, long length) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x2, long length) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        this.updateClob(columnIndex, reader, length);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        this.updateClob(columnLabel, reader, length);
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x2) throws SQLException {
        this.updateCharacterStream(columnIndex, x2);
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        this.updateCharacterStream(columnLabel, reader);
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x2) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x2) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x2) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x2) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x2) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        this.updateClob(columnIndex, reader);
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        this.updateClob(columnLabel, reader);
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        DBError.ECJDBC_UNSUPPORTED_INTERFACE.throwz(new Object[0]);
        return null;
    }
}

