/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.conf;

import dm.jdbc.driver.Configuration;
import dm.jdbc.util.ConvertUtil;
import dm.jdbc.util.StringUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class DmProperties
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private Map<Object, Object> innerProps = new HashMap<Object, Object>();

    public DmProperties() {
    }

    public DmProperties(DmProperties props) {
        this();
        this.setProperties(props.innerProps);
    }

    public Properties getProperties() {
        Properties props = new Properties();
        if (this.innerProps != null) {
            for (Map.Entry<Object, Object> e2 : this.innerProps.entrySet()) {
                if (e2 == null) continue;
                props.put(e2.getKey().toString().toLowerCase(), e2.getValue());
            }
        }
        return props;
    }

    public int size() {
        return this.innerProps.size();
    }

    public void setProperties(Properties props) {
        if (props != null) {
            for (Map.Entry<Object, Object> e2 : props.entrySet()) {
                if (e2 == null) continue;
                this.innerProps.put(e2.getKey().toString().toLowerCase(), e2.getValue());
            }
        }
    }

    public void setProperties(Map<Object, Object> props) {
        if (props != null) {
            for (Map.Entry<Object, Object> e2 : props.entrySet()) {
                if (e2 == null) continue;
                this.innerProps.put(e2.getKey().toString().toLowerCase(), e2.getValue());
            }
        }
    }

    public void setNonExistProperties(DmProperties props) {
        if (props != null) {
            this.setNonExistProperties(props.innerProps);
        }
    }

    public void setNonExistProperties(Properties props) {
        if (props != null) {
            for (Map.Entry<Object, Object> e2 : props.entrySet()) {
                String key = e2.getKey().toString().toLowerCase();
                if (this.innerProps.containsKey(key)) continue;
                this.innerProps.put(key, e2.getValue());
            }
        }
    }

    public void setNonExistProperties(Map<Object, Object> props) {
        if (props != null) {
            for (Map.Entry<Object, Object> e2 : props.entrySet()) {
                String key = e2.getKey().toString().toLowerCase();
                if (this.innerProps.containsKey(key)) continue;
                this.innerProps.put(key, e2.getValue());
            }
        }
    }

    public Object setNonExistProperty(String key, String value) {
        if (!this.innerProps.containsKey(key.toLowerCase())) {
            return this.innerProps.put(key.toLowerCase(), value);
        }
        return this.innerProps.get(key.toLowerCase());
    }

    public Object setProperty(String key, String value) {
        return this.innerProps.put(key.toLowerCase(), value);
    }

    public String getProperty(String key) {
        Object obj = this.innerProps.get(key.toLowerCase());
        return obj != null ? obj.toString() : null;
    }

    public String getProperty(String key, String def) {
        String value = this.getProperty(key);
        return StringUtil.isEmpty(value) ? def : value;
    }

    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.innerProps.entrySet();
    }

    public Object setObject(String key, Object obj) {
        return this.innerProps.put(key.toLowerCase(), obj);
    }

    public Object getObject(String key) {
        return this.innerProps.get(key.toLowerCase());
    }

    public boolean contains(Configuration<?> item) {
        String value = this.getProperty(item.getName());
        return StringUtil.isNotEmpty(value);
    }

    public boolean getBoolean(Configuration<Boolean> item) {
        String value = this.getProperty(item.getName());
        return StringUtil.isEmpty(value) ? item.getDefault() : ConvertUtil.toBoolean(value);
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        String value = this.getProperty(name);
        return StringUtil.isEmpty(value) ? defaultValue : ConvertUtil.toBoolean(value);
    }

    public int getInt(String name, int defaultValue) {
        String value = this.getProperty(name);
        if (StringUtil.isEmpty(value)) {
            return defaultValue;
        }
        try {
            int intValue = StringUtil.isInteger(value) ? Integer.valueOf(value) : (Boolean.valueOf(value) != false ? 1 : 0);
            return intValue;
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public int getInt(Configuration<Integer> item) {
        String value = this.getProperty(item.getName());
        if (StringUtil.isEmpty(value)) {
            return item.getDefault();
        }
        try {
            int intValue = StringUtil.isInteger(value) ? Integer.valueOf(value) : (Boolean.valueOf(value) != false ? 1 : 0);
            return this.getIntInner(item, intValue);
        }
        catch (Exception exception) {
            return item.getDefault();
        }
    }

    protected int getIntInner(Configuration<Integer> item, int intValue) {
        if (item.getMax() != null && intValue > item.getMax()) {
            return item.getDefault();
        }
        if (item.getMin() != null && intValue < item.getMin()) {
            return item.getDefault();
        }
        if (item.getValidValues() != null) {
            Integer[] integerArray = item.getValidValues();
            int n2 = integerArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Integer validValue = integerArray[n3];
                if (intValue == validValue) {
                    return intValue;
                }
                ++n3;
            }
            return item.getDefault();
        }
        return intValue;
    }

    public long getLong(Configuration<Long> item) {
        String value = this.getProperty(item.getName());
        if (StringUtil.isEmpty(value)) {
            return item.getDefault();
        }
        try {
            long longValue = StringUtil.isLong(value) ? Long.valueOf(value) : (long)(Boolean.valueOf(value) != false ? 1 : 0);
            return this.getLongInner(item, longValue);
        }
        catch (Exception exception) {
            return item.getDefault();
        }
    }

    protected long getLongInner(Configuration<Long> item, long longValue) {
        if (item.getMax() != null && longValue > item.getMax()) {
            return item.getDefault();
        }
        if (item.getMin() != null && longValue < item.getMin()) {
            return item.getDefault();
        }
        if (item.getValidValues() != null) {
            Long[] longArray = item.getValidValues();
            int n2 = longArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Long validValue = longArray[n3];
                if (longValue == validValue) {
                    return longValue;
                }
                ++n3;
            }
            return item.getDefault();
        }
        return longValue;
    }

    public String getString(String name, String defaultValue) {
        String value = this.getProperty(name);
        if (StringUtil.isEmpty(value)) {
            return defaultValue;
        }
        return value;
    }

    public String getString(Configuration<String> item) {
        String value = this.getProperty(item.getName());
        if (StringUtil.isEmpty(value)) {
            return item.getDefault();
        }
        return value;
    }

    public String getTrimString(Configuration<String> item) {
        String value = this.getProperty(item.getName());
        if (StringUtil.isEmpty(value)) {
            return item.getDefault();
        }
        return StringUtil.trimToEmpty(value);
    }

    public String[] getStringArray(Configuration<String[]> item) {
        String[] array;
        String value = this.getProperty(item.getName());
        if (value != null && (array = value.split(",")).length > 0) {
            return array;
        }
        return item.getDefault();
    }

    public int getMilliSecond(Configuration<Integer> item) {
        String value = this.getProperty(item.getName());
        if (StringUtil.isEmpty(value)) {
            return item.getDefault();
        }
        value = value.toLowerCase();
        int unit = 1;
        if (value.endsWith("h")) {
            value = value.substring(0, value.length() - 1);
            unit = 3600000;
        } else if (value.endsWith("m")) {
            value = value.substring(0, value.length() - 1);
            unit = 60000;
        } else if (value.endsWith("ms")) {
            value = value.substring(0, value.length() - 2);
            unit = 1;
        } else if (value.endsWith("s")) {
            value = value.substring(0, value.length() - 1);
            unit = 1000;
        } else {
            return this.getInt(item);
        }
        try {
            value = StringUtil.trimToEmpty(value);
            if (StringUtil.isEmpty(value)) {
                return item.getDefault();
            }
            int intValue = StringUtil.isInteger(value) ? Integer.valueOf(value) : (Boolean.valueOf(value) != false ? 1 : 0);
            return this.getIntInner(item, intValue *= unit);
        }
        catch (Exception exception) {
            return item.getDefault();
        }
    }

    public int getSecond(Configuration<Integer> item) {
        String value = this.getProperty(item.getName());
        if (StringUtil.isEmpty(value)) {
            return item.getDefault();
        }
        value = value.toLowerCase();
        double unit = 1.0;
        if (value.endsWith("h")) {
            value = value.substring(0, value.length() - 1);
            unit = 3600.0;
        } else if (value.endsWith("m")) {
            value = value.substring(0, value.length() - 1);
            unit = 60.0;
        } else if (value.endsWith("ms")) {
            value = value.substring(0, value.length() - 2);
            unit = 0.001;
        } else if (value.endsWith("s")) {
            value = value.substring(0, value.length() - 1);
            unit = 1.0;
        } else {
            return this.getInt(item);
        }
        try {
            value = StringUtil.trimToEmpty(value);
            if (StringUtil.isEmpty(value)) {
                return item.getDefault();
            }
            int intValue = StringUtil.isInteger(value) ? Integer.valueOf(value) : (Boolean.valueOf(value) != false ? 1 : 0);
            intValue = (int)((double)intValue * unit);
            return this.getIntInner(item, intValue);
        }
        catch (Exception exception) {
            return item.getDefault();
        }
    }

    public Object clone() {
        DmProperties newProps = new DmProperties();
        newProps.setProperties(this.innerProps);
        return newProps;
    }

    public String toString() {
        String str = this.innerProps.toString();
        int index = str.indexOf("password=");
        if (index != -1) {
            int end = str.indexOf(",", index);
            str = String.valueOf(str.substring(0, index)) + str.substring(end);
        }
        return str;
    }
}

