/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.convert;

import dm.jdbc.internal.IDmdbConnection;
import dm.jdbc.util.ByteArrayQueue;
import java.nio.charset.Charset;
import java.sql.SQLException;

public abstract class OffRowData {
    public Object obj;
    public Charset encoding;
    protected boolean readOver = false;
    public ByteArrayQueue buffer;
    public long position = 0L;
    public boolean offRow = false;
    public long targetLength = -1L;
    public int READ_LEN;
    public int OFF_ROW_LEN;

    protected OffRowData(Object obj, IDmdbConnection conn, long targetLength) throws SQLException {
        this.targetLength = targetLength;
        this.obj = obj;
        this.encoding = conn.getServerEncoding();
        this.READ_LEN = conn.getLobReadWriteLen();
        this.OFF_ROW_LEN = conn.getLobOffRowLen();
        this.buffer = new ByteArrayQueue();
    }

    protected void init() throws SQLException {
        this.read(this.buffer);
        this.offRow = this.buffer.length() > this.OFF_ROW_LEN;
    }

    public int getBufferLeaveLen() {
        return this.buffer.length();
    }

    protected void readFromBuffer(ByteArrayQueue byteArray) {
        byteArray.append(this.buffer);
    }

    public abstract void read(ByteArrayQueue var1) throws SQLException;

    public abstract byte[] readAll() throws SQLException;

    public boolean isReadOver() {
        return this.readOver && this.getBufferLeaveLen() == 0;
    }
}

