/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.internal.desc;

import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.internal.desc.Column;
import java.io.Closeable;
import java.sql.SQLException;

public class Parameter
extends Column
implements Closeable {
    public static final int PARAM_COUNT_LIMIT = 65536;
    public static final byte TYPE_FLAG_UNKNOWN = 0;
    public static final byte TYPE_FLAG_EXACT = 1;
    public static final byte TYPE_FLAG_RECOMMEND = 2;
    public byte typeFlag = 0;
    public static final byte IO_TYPE_UNKNOWN = -1;
    public static final byte IO_TYPE_IN = 0;
    public static final byte IO_TYPE_OUT = 1;
    public static final byte IO_TYPE_INOUT = 2;
    public byte ioType = (byte)-1;
    public int outJType = Integer.MIN_VALUE;
    public int outScale = -1;
    public String outObjectName;
    public DmdbStatement cursorStmt;
    public boolean hasDefault;

    public static boolean useClientBind(DmdbConnection conn, Parameter serverParam, boolean isNull) {
        if (serverParam == null || serverParam.type == 54) {
            return true;
        }
        return conn.paramBindMode != 1 && serverParam.typeFlag != 1 && serverParam.mask == 0 && !isNull;
    }

    public void recommendType(DmdbConnection conn, Parameter serverParam, int type, boolean isNull) {
        if (Parameter.useClientBind(conn, serverParam, isNull)) {
            this.resetType(type);
        } else {
            this.type = serverParam.type;
            this.prec = serverParam.prec;
            this.scale = serverParam.scale;
            this.mask = serverParam.mask;
        }
    }

    public void resetType(int type) {
        this.type = type;
        this.scale = 0;
        switch (type) {
            case 3: 
            case 13: {
                this.prec = 1;
                break;
            }
            case 5: {
                this.prec = 1;
                break;
            }
            case 6: {
                this.prec = 2;
                break;
            }
            case 7: {
                this.prec = 4;
                break;
            }
            case 8: {
                this.prec = 8;
                break;
            }
            case 0: 
            case 1: 
            case 2: {
                this.prec = Short.MAX_VALUE;
                break;
            }
            case 19: {
                this.prec = Integer.MAX_VALUE;
                break;
            }
            case 17: 
            case 18: {
                this.prec = Short.MAX_VALUE;
                break;
            }
            case 12: {
                this.prec = Integer.MAX_VALUE;
                break;
            }
            case 14: {
                this.prec = 3;
                break;
            }
            case 15: {
                this.prec = 5;
                this.scale = 6;
                break;
            }
            case 22: {
                this.prec = 7;
                this.scale = 6;
                break;
            }
            case 16: {
                this.prec = 8;
                this.scale = 6;
                break;
            }
            case 23: {
                this.prec = 10;
                this.scale = 6;
                break;
            }
            case 26: {
                this.prec = 9;
                this.scale = 9;
                break;
            }
            case 27: {
                this.prec = 11;
                this.scale = 9;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 117: 
            case 119: 
            case 121: 
            case 122: {
                this.prec = 0;
                break;
            }
            case 29: 
            case 54: {
                this.type = 2;
                this.prec = Short.MAX_VALUE;
                break;
            }
        }
    }

    public void clear() {
        this.outJType = Integer.MIN_VALUE;
        this.outScale = -1;
        this.outObjectName = null;
        if (this.cursorStmt != null) {
            try {
                this.cursorStmt.do_close();
            }
            catch (SQLException sQLException) {}
        }
        this.cursorStmt = null;
        this.ioType = (byte)-1;
        this.name = "";
        this.mask = 0;
    }

    @Override
    public void close() {
        if (this.cursorStmt != null) {
            try {
                this.cursorStmt.do_close();
            }
            catch (SQLException sQLException) {}
        }
        this.cursorStmt = null;
    }

    @Override
    public String toString() {
        return "[type: " + this.type + ", prec: " + this.prec + ", scale: " + this.scale + ", typeFlag: " + this.typeFlag + "]";
    }

    public void reset(Parameter newColumn) {
        super.reset(newColumn);
        this.hasDefault = newColumn.hasDefault;
        this.ioType = newColumn.ioType;
        this.outJType = newColumn.outJType;
        this.outObjectName = newColumn.outObjectName;
        this.outScale = newColumn.outScale;
        this.typeFlag = newColumn.typeFlag;
        this.cursorStmt = newColumn.cursorStmt;
    }

    public Parameter clone(DmdbConnection conn, DmdbPreparedStatement pstmt) throws SQLException {
        Parameter param = new Parameter();
        param.reset(this);
        if (this.cursorStmt != null && !this.cursorStmt.closed && conn != null && pstmt != null) {
            param.cursorStmt = conn.createCursorStatement(pstmt.resultSetType, pstmt.resultSetConcurrency, pstmt.resultSetHoldability);
        }
        return param;
    }

    public static boolean typeEquals(Parameter[] oldParams, Parameter[] newParams) {
        int i2 = 0;
        while (i2 < oldParams.length) {
            if (oldParams[i2] != null || newParams[i2] != null) {
                if (oldParams[i2] == null || newParams[i2] == null) {
                    return false;
                }
                if (oldParams[i2].type != newParams[i2].type || oldParams[i2].prec != newParams[i2].prec || oldParams[i2].scale != newParams[i2].scale || oldParams[i2].name != newParams[i2].name || oldParams[i2].ioType != newParams[i2].ioType || oldParams[i2].typeDescriptor != newParams[i2].typeDescriptor || oldParams[i2].mask != newParams[i2].mask) {
                    return false;
                }
            }
            ++i2;
        }
        return true;
    }
}

