/*
 * Decompiled with CFR 0.152.
 */
package com.dangdang.ddframe.job.lite.lifecycle.internal.operate;

import com.dangdang.ddframe.job.lite.internal.storage.JobNodePath;
import com.dangdang.ddframe.job.lite.lifecycle.api.JobOperateAPI;
import com.dangdang.ddframe.job.reg.base.CoordinatorRegistryCenter;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.List;

public final class JobOperateAPIImpl
implements JobOperateAPI {
    private final CoordinatorRegistryCenter regCenter;

    public JobOperateAPIImpl(CoordinatorRegistryCenter regCenter) {
        this.regCenter = regCenter;
    }

    @Override
    public void trigger(Optional<String> jobName, Optional<String> serverIp) {
        if (jobName.isPresent()) {
            JobNodePath jobNodePath = new JobNodePath((String)jobName.get());
            for (String each : this.regCenter.getChildrenKeys(jobNodePath.getInstancesNodePath())) {
                this.regCenter.persist(jobNodePath.getInstanceNodePath(each), "TRIGGER");
            }
        }
    }

    @Override
    public void disable(Optional<String> jobName, Optional<String> serverIp) {
        this.disableOrEnableJobs(jobName, serverIp, true);
    }

    @Override
    public void enable(Optional<String> jobName, Optional<String> serverIp) {
        this.disableOrEnableJobs(jobName, serverIp, false);
    }

    private void disableOrEnableJobs(Optional<String> jobName, Optional<String> serverIp, boolean disabled) {
        block4: {
            block5: {
                block3: {
                    Preconditions.checkArgument((jobName.isPresent() || serverIp.isPresent() ? 1 : 0) != 0, (Object)"At least indicate jobName or serverIp.");
                    if (!jobName.isPresent() || !serverIp.isPresent()) break block3;
                    this.persistDisabledOrEnabledJob((String)jobName.get(), (String)serverIp.get(), disabled);
                    break block4;
                }
                if (!jobName.isPresent()) break block5;
                JobNodePath jobNodePath = new JobNodePath((String)jobName.get());
                for (String each : this.regCenter.getChildrenKeys(jobNodePath.getServerNodePath())) {
                    if (disabled) {
                        this.regCenter.persist(jobNodePath.getServerNodePath(each), "DISABLED");
                        continue;
                    }
                    this.regCenter.persist(jobNodePath.getServerNodePath(each), "");
                }
                break block4;
            }
            if (!serverIp.isPresent()) break block4;
            List jobNames = this.regCenter.getChildrenKeys("/");
            for (String each : jobNames) {
                if (!this.regCenter.isExisted(new JobNodePath(each).getServerNodePath((String)serverIp.get()))) continue;
                this.persistDisabledOrEnabledJob(each, (String)serverIp.get(), disabled);
            }
        }
    }

    private void persistDisabledOrEnabledJob(String jobName, String serverIp, boolean disabled) {
        JobNodePath jobNodePath = new JobNodePath(jobName);
        String serverNodePath = jobNodePath.getServerNodePath(serverIp);
        if (disabled) {
            this.regCenter.persist(serverNodePath, "DISABLED");
        } else {
            this.regCenter.persist(serverNodePath, "");
        }
    }

    @Override
    public void shutdown(Optional<String> jobName, Optional<String> serverIp) {
        block5: {
            block6: {
                block4: {
                    Preconditions.checkArgument((jobName.isPresent() || serverIp.isPresent() ? 1 : 0) != 0, (Object)"At least indicate jobName or serverIp.");
                    if (!jobName.isPresent() || !serverIp.isPresent()) break block4;
                    JobNodePath jobNodePath = new JobNodePath((String)jobName.get());
                    for (String each : this.regCenter.getChildrenKeys(jobNodePath.getInstancesNodePath())) {
                        if (!((String)serverIp.get()).equals(each.split("@-@")[0])) continue;
                        this.regCenter.remove(jobNodePath.getInstanceNodePath(each));
                    }
                    break block5;
                }
                if (!jobName.isPresent()) break block6;
                JobNodePath jobNodePath = new JobNodePath((String)jobName.get());
                for (String each : this.regCenter.getChildrenKeys(jobNodePath.getInstancesNodePath())) {
                    this.regCenter.remove(jobNodePath.getInstanceNodePath(each));
                }
                break block5;
            }
            if (!serverIp.isPresent()) break block5;
            List jobNames = this.regCenter.getChildrenKeys("/");
            for (String job : jobNames) {
                JobNodePath jobNodePath = new JobNodePath(job);
                List instances = this.regCenter.getChildrenKeys(jobNodePath.getInstancesNodePath());
                for (String each : instances) {
                    if (!((String)serverIp.get()).equals(each.split("@-@")[0])) continue;
                    this.regCenter.remove(jobNodePath.getInstanceNodePath(each));
                }
            }
        }
    }

    @Override
    public void remove(Optional<String> jobName, Optional<String> serverIp) {
        block3: {
            block4: {
                block2: {
                    this.shutdown(jobName, serverIp);
                    if (!jobName.isPresent() || !serverIp.isPresent()) break block2;
                    this.regCenter.remove(new JobNodePath((String)jobName.get()).getServerNodePath((String)serverIp.get()));
                    break block3;
                }
                if (!jobName.isPresent()) break block4;
                JobNodePath jobNodePath = new JobNodePath((String)jobName.get());
                List servers = this.regCenter.getChildrenKeys(jobNodePath.getServerNodePath());
                for (String each : servers) {
                    this.regCenter.remove(jobNodePath.getServerNodePath(each));
                }
                break block3;
            }
            if (!serverIp.isPresent()) break block3;
            List jobNames = this.regCenter.getChildrenKeys("/");
            for (String each : jobNames) {
                this.regCenter.remove(new JobNodePath(each).getServerNodePath((String)serverIp.get()));
            }
        }
    }
}

