/*
 * Copyright 2020 Beijing Volcano Engine Technology Co., Ltd.
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file except in compliance with the License. You may obtain a copy of the License at
 * http://www.apache.org/licenses/LICENSE-2.0
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions and limitations under the License.
 */
package com.datarangers.event;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;

import java.io.Serializable;
import java.util.Map;

@JsonDeserialize(as = EventV3.class)
public interface Event extends Serializable {
    Event setEvent(String event);

    Event setParams(Map<String, Object> params);

    Event addParams(String key, Object value);

    Event setLocalTimeMs(Long localTimeMs);

    Event setAbSdkVersion(String abSdkVersion);

    String key();

    String getEvent();

    String getDatetime();
}
