/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.asynccollector;

import com.datarangers.asynccollector.CollectorContainer;
import com.datarangers.config.DataRangersSDKConfigProperties;
import com.datarangers.config.RangersJSONConfig;
import com.datarangers.config.SdkMode;
import com.datarangers.logger.RangersLoggerWriterPool;
import com.datarangers.message.AppMessage;
import com.datarangers.message.Message;
import com.datarangers.sender.MessageSenderFactory;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Consumer
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(Consumer.class);
    private static RangersLoggerWriterPool pool;
    private CollectorContainer collectorContainer;
    private DataRangersSDKConfigProperties sdkConfigProperties;

    public Consumer(CollectorContainer collectorContainer, DataRangersSDKConfigProperties sdkConfigProperties) {
        this.collectorContainer = collectorContainer;
        this.sdkConfigProperties = sdkConfigProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setWriterPool(List<String> targetPrefixes, String targetNames, int maxSize) {
        if (pool != null) return;
        Class<Consumer> clazz = Consumer.class;
        synchronized (Consumer.class) {
            if (pool != null) return;
            pool = RangersLoggerWriterPool.getInstance(targetPrefixes, targetNames, maxSize);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private void send() throws Exception {
        while (true) {
            try {
                while (true) {
                    List<Message> messages;
                    if ((messages = this.collectorContainer.consume()) == null) {
                        continue;
                    }
                    messages.forEach(message -> this.doSend((Message)message));
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                logger.error("consumer send error", e);
                continue;
            }
            break;
        }
    }

    private void sendBatch() throws Exception {
        while (true) {
            try {
                while (true) {
                    List<Message> messages;
                    if ((messages = this.collectorContainer.consume(this.sdkConfigProperties.getBatchSize(), this.sdkConfigProperties.getWaitTimeMs())) == null || messages.size() <= 0) {
                        continue;
                    }
                    MessageSenderFactory.getMessageSender(messages.get(0)).sendBatch(messages, this.sdkConfigProperties);
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
                logger.error("consumer send error", e);
                continue;
            }
            break;
        }
    }

    private void write() throws Exception {
        while (true) {
            try {
                while (true) {
                    List<Message> messages;
                    if ((messages = this.collectorContainer.consume()) == null) {
                        continue;
                    }
                    messages.forEach(message -> this.doWrite((Message)message));
                }
            }
            catch (Throwable e) {
                logger.error("consumer write error", e);
                continue;
            }
            break;
        }
    }

    @Override
    public void run() {
        try {
            if (SdkMode.FILE == this.sdkConfigProperties.getMode()) {
                this.write();
            } else if (this.sdkConfigProperties.isSendBatch()) {
                this.sendBatch();
            } else {
                this.send();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("consumer run error", (Throwable)e);
        }
    }

    public void flush() {
        try {
            System.out.println("flush message start");
            logger.info("flush message start");
            int count = 0;
            if (this.collectorContainer.getMessageQueue() != null) {
                Message message = this.collectorContainer.getMessageQueue().poll();
                while (message != null) {
                    ++count;
                    message = this.collectorContainer.handleMessage(message);
                    if (SdkMode.FILE == this.sdkConfigProperties.getMode()) {
                        this.doWrite(message);
                    } else {
                        this.doSend(message);
                    }
                    message = this.collectorContainer.getMessageQueue().poll();
                }
            }
            logger.info("flush message success. size: {}", (Object)count);
            System.out.println("flush message success. size: " + count);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("flush message error", (Throwable)e);
        }
    }

    public void flush(Message message) {
        message = this.collectorContainer.handleMessage(message);
        if (SdkMode.FILE == this.sdkConfigProperties.getMode()) {
            this.doWrite(message);
        } else {
            this.doSend(message);
        }
    }

    private void doSend(Message message) {
        MessageSenderFactory.getMessageSender(message).send(message, this.sdkConfigProperties);
    }

    private void doWrite(Message message) {
        AppMessage appMessage = message.getAppMessage();
        pool.getWriter(appMessage.getUserUniqueId()).write(RangersJSONConfig.getInstance().toJson(appMessage) + "\n");
    }
}

