/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.collector;

import com.datarangers.collector.Collector;
import com.datarangers.config.DataRangersSDKConfigProperties;
import com.datarangers.config.ProducerConfig;
import com.datarangers.config.RangersJSONConfig;
import com.datarangers.event.Event;
import com.datarangers.event.EventV3;
import com.datarangers.event.Header;
import com.datarangers.event.HeaderV3;
import com.datarangers.event.Item;
import com.datarangers.message.AppMessage;
import com.datarangers.message.Message;
import com.datarangers.message.MessageType;
import com.datarangers.profile.ItemMethod;
import com.datarangers.profile.ProfileMethod;
import com.datarangers.sender.Callback;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class AppEventCollector
extends Collector {
    public AppEventCollector(String appType, DataRangersSDKConfigProperties properties) {
        this(appType, properties, null);
    }

    public AppEventCollector(String appType, DataRangersSDKConfigProperties properties, Callback cb) {
        super(appType, properties, cb);
    }

    public AppEventCollector(String appType, DataRangersSDKConfigProperties properties, Callback cb, ProducerConfig producerConfig) {
        super(appType, properties, cb, producerConfig);
    }

    @Override
    public void sendEvent(String userUniqueId, int appId, Map<String, Object> custom, String eventName, Map<String, Object> eventParams) {
        this.sendEvent(userUniqueId, appId, custom, eventName, eventParams, System.currentTimeMillis());
    }

    @Override
    public void sendEvent(String userUniqueId, int appId, Map<String, Object> custom, String eventName, Map<String, Object> eventParams, long localTimeMs) {
        if (eventParams == null) {
            logger.error("userUniqueId=" + userUniqueId + ",appId=" + appId + ",eventName=" + eventName + " params are null");
            return;
        }
        Header header = new HeaderV3.Builder().setCustom(custom).setAppId(appId).setUserUniqueId(userUniqueId).build();
        EventV3 event = ((EventV3)new EventV3().setEvent(eventName).setParams((Map)eventParams)).setUserId(userUniqueId).setLocalTimeMs(localTimeMs);
        this.sendEvent(header, event, MessageType.EVENT);
    }

    @Override
    public void sendEvent(Header header, String eventName, Map<String, Object> eventParams) {
        this.sendEvent(header, eventName, eventParams, System.currentTimeMillis());
    }

    @Override
    public void sendEvent(Header header, String eventName, Map<String, Object> eventParams, long localTimeMs) {
        if (eventParams == null) {
            logger.error("userUniqueId=" + header.getUserUniqueId() + ",appId=" + header.getAppId() + ",eventName=" + eventName + " params are null");
            return;
        }
        EventV3 event = ((EventV3)new EventV3().setEvent(eventName).setParams((Map)eventParams)).setUserId(header.getUserUniqueId()).setLocalTimeMs(localTimeMs);
        this.sendEvent(header, event, MessageType.EVENT);
    }

    @Override
    @Deprecated
    public void sendEvent(Header header, List<String> eventName, List<Map<String, Object>> eventParams) {
        ArrayList<Event> events = new ArrayList<Event>();
        for (int i = 0; i < Math.min(eventName.size(), eventParams.size()); ++i) {
            if (eventParams.get(i) == null) continue;
            EventV3 event = ((EventV3)new EventV3().setEvent(eventName.get(i)).setParams((Map)eventParams.get(i))).setUserId(header.getUserUniqueId());
            events.add(event);
        }
        this.sendEvents(header, events);
    }

    private void profile(String userUniqueId, int appId, ProfileMethod method, Map<String, Object> eventParams) {
        if (eventParams == null) {
            logger.error("userUniqueId=" + userUniqueId + ",appId=" + appId + ",eventName=" + method.getMethod() + " params are null");
            return;
        }
        Header header = new HeaderV3.Builder().setAppId(appId).setUserUniqueId(userUniqueId).build();
        EventV3 event = ((EventV3)new EventV3().setEvent(method.toString()).setParams((Map)eventParams)).setUserId(userUniqueId);
        this.sendEvent(header, event, MessageType.PROFILE);
    }

    private void profile(Header header, ProfileMethod method, Map<String, Object> profiles) {
        if (header == null || header.getAppId() == null) {
            logger.error("header is null or appId is empty");
            return;
        }
        if (profiles == null) {
            logger.error("userUniqueId={}, app_id={}, device_id={} params are null.", new Object[]{header.getUserUniqueId(), header.getAppId(), header.getDeviceId()});
            return;
        }
        EventV3 event = ((EventV3)new EventV3().setEvent(method.toString()).setParams((Map)profiles)).setUserId(header.getUserUniqueId());
        this.sendEvent(header, event, MessageType.PROFILE);
    }

    @Override
    public void profileSet(String userUniqueId, int appId, Map<String, Object> eventParams) {
        this.profile(userUniqueId, appId, ProfileMethod.SET, eventParams);
    }

    @Override
    public void profileSetOnce(String userUniqueId, int appId, Map<String, Object> eventParams) {
        this.profile(userUniqueId, appId, ProfileMethod.SET_ONCE, eventParams);
    }

    @Override
    public void profileIncrement(String userUniqueId, int appId, Map<String, Object> eventParams) {
        this.profile(userUniqueId, appId, ProfileMethod.INCREMENT, eventParams);
    }

    @Override
    public void profileUnset(String userUniqueId, int appId, List<String> params) {
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        params.forEach(p -> eventParams.put((String)p, "java"));
        this.profile(userUniqueId, appId, ProfileMethod.UNSET, eventParams);
    }

    @Override
    public void profileSet(Header header, Map<String, Object> profiles) {
        this.profile(header, ProfileMethod.SET, profiles);
    }

    @Override
    public void profileSetOnce(Header header, Map<String, Object> profiles) {
        this.profile(header, ProfileMethod.SET_ONCE, profiles);
    }

    @Override
    public void profileIncrement(Header header, Map<String, Object> profiles) {
        this.profile(header, ProfileMethod.INCREMENT, profiles);
    }

    @Override
    public void profileAppend(Header header, Map<String, Object> profiles) {
        this.profile(header, ProfileMethod.APPEND, profiles);
    }

    @Override
    public void profileUnset(Header header, List<String> profiles) {
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        profiles.forEach(p -> eventParams.put((String)p, "java"));
        this.profile(header, ProfileMethod.UNSET, eventParams);
    }

    @Override
    public void profileAppend(String userUniqueId, int appId, Map<String, Object> eventParams) {
        this.profile(userUniqueId, appId, ProfileMethod.APPEND, eventParams);
    }

    @Override
    public void itemSet(int appId, String itemName, List<Item> items) {
        this.item(ItemMethod.SET.toString(), appId, items);
    }

    @Override
    public void itemUnset(int appId, String id, String name, List<String> params) {
        Header header = new HeaderV3.Builder().setAppId(appId).setUserUniqueId("__rangers").build();
        ArrayList<Event> events = new ArrayList<Event>();
        HashMap<String, Object> eventParams = new HashMap<String, Object>();
        params.forEach(p -> eventParams.put((String)p, ""));
        events.add(new EventV3().setEvent(ItemMethod.UNSET.toString()).addParams("item_id", id).addParams("item_name", name).setParams(eventParams));
        this.sendEvents(header, events, MessageType.ITEM);
    }

    private void itemDelete(int appId, List<Item> items) {
        this.item(ItemMethod.DELETE.toString(), appId, items);
    }

    private void item(String eventName, int appId, List<Item> items) {
        if (items == null) {
            logger.error("appId=" + appId + ",eventName=" + eventName + " params are null");
            return;
        }
        Header header = new HeaderV3.Builder().setAppId(appId).setUserUniqueId("__rangers").build();
        ArrayList<Event> events = new ArrayList<Event>();
        for (Item item : items) {
            if (item == null) continue;
            EventV3 event = new EventV3().setEvent(eventName);
            try {
                RangersJSONConfig.getInstance().fromJson(RangersJSONConfig.getInstance().toJson(item), Map.class).forEach((key, value) -> event.addParams((String)key, value));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            events.add(event);
        }
        this.sendEvents(header, events, MessageType.ITEM);
    }

    @Override
    @Deprecated
    public void sendProfiles(String userUniqueId, int appId, List<ProfileMethod> profileModes, List<Map<String, Object>> profiles) {
        Header header = new HeaderV3.Builder().setAppId(appId).setUserUniqueId(userUniqueId).build();
        ArrayList<Event> events = new ArrayList<Event>();
        for (int i = 0; i < Math.min(profileModes.size(), profiles.size()); ++i) {
            Event event = new EventV3().setEvent(profileModes.get(i).getMethod()).setParams((Map)profiles.get(i));
            events.add(event);
        }
        this.sendEvents(header, events, MessageType.PROFILE);
    }

    private void sendEvent(Header header, Event event, MessageType messageType) {
        Message message = new Message();
        message.setMessageEnv(this.properties.getMessageEnv());
        message.setMessageType(messageType);
        AppMessage appMessage = new AppMessage();
        appMessage.setUserUniqueId(header.getUserUniqueId());
        appMessage.setAppType(this.getAppType());
        appMessage.setHeader(header);
        appMessage.addEvent(event);
        message.setAppMessage(appMessage);
        this.send(message);
    }

    private void sendEvents(Header header, List<Event> events, MessageType messageType) {
        Message message = new Message();
        message.setMessageEnv(this.properties.getMessageEnv());
        message.setMessageType(messageType);
        AppMessage appMessage = new AppMessage();
        appMessage.setUserUniqueId(header.getUserUniqueId());
        appMessage.setAppType(this.getAppType());
        appMessage.setHeader(header);
        appMessage.addEvents(events);
        appMessage.setTraceId(UUID.randomUUID().toString());
        message.setAppMessage(appMessage);
        this.send(message);
    }

    @Override
    public void sendEvents(Header header, List<Event> events) {
        this.sendEvents(header, events, MessageType.EVENT);
    }
}

