/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.logger;

import com.datarangers.asynccollector.CollectorContainer;
import com.datarangers.util.HttpUtils;
import java.io.File;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;

public class RangersFileCleaner
implements Runnable {
    public List<String> eventFilePaths;
    public String name;
    public int maxDays;
    public static final DateTimeFormatter FULL_TIME = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH");

    public RangersFileCleaner(List<String> eventFilePaths, String fileName, int maxDays) {
        this.name = fileName;
        this.maxDays = maxDays;
        this.eventFilePaths = eventFilePaths;
    }

    private void delete(String path) {
        File parent;
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (!(parent = new File(path)).exists()) {
            return;
        }
        try {
            String firstDay = LocalDateTime.now().plusDays(-this.maxDays).format(FULL_TIME);
            for (File f : parent.listFiles()) {
                String arr;
                if (!f.getName().contains(this.name) || f.getName().equals(this.name) || (arr = f.getName().replace(this.name, "")).length() <= 11 || firstDay.compareTo(arr = arr.substring(1, 11)) <= 0) continue;
                new File(path + "/" + f.getName()).delete();
                HttpUtils.logger.warn("delete " + path + "/" + f.getName());
                System.out.println("delete " + path + "/" + f.getName());
            }
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
    }

    private void delete() {
        this.eventFilePaths.forEach(this::delete);
    }

    private void release() {
        String firstDay = LocalDateTime.now().plusDays(-this.maxDays).format(FULL_TIME);
        CollectorContainer.SEND_HISTORY.entrySet().removeIf(entry -> firstDay.compareTo((String)entry.getKey()) > 0);
    }

    @Override
    public void run() {
        this.delete();
        this.release();
    }
}

