/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.message.saas;

import com.datarangers.event.Event;
import com.datarangers.event.EventV3;
import com.datarangers.message.Message;
import com.datarangers.message.saas.Attribute;
import com.datarangers.profile.ProfileMethod;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SaasProfileAppMessage {
    private static final Map<String, String> operationMap = new HashMap(){
        {
            this.put(ProfileMethod.SET.toString(), "SET");
            this.put(ProfileMethod.SET_ONCE.toString(), "SET_ONCE");
            this.put(ProfileMethod.APPEND.toString(), "APPEND");
            this.put(ProfileMethod.INCREMENT.toString(), "INCREASE");
            this.put(ProfileMethod.UNSET.toString(), "UNSET");
        }
    };
    private List<Attribute> attributes = new ArrayList<Attribute>();

    public SaasProfileAppMessage() {
    }

    public SaasProfileAppMessage(Message message) {
        List<Event> events = message.getAppMessage().getEvents();
        for (Event event : events) {
            EventV3 eventV3 = (EventV3)event;
            for (Map.Entry<String, Object> entry : eventV3.getParams().entrySet()) {
                String key = entry.getKey();
                if ("item_id".equals(key) || "item_name".equals(key)) continue;
                this.addAttribute(key, entry.getValue(), eventV3.getEvent());
            }
        }
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<Attribute> attributes) {
        this.attributes = attributes;
    }

    protected void addAttribute(String name, Object value, String method) {
        String operation = this.operationConvert(method);
        if (operation == null || operation.isEmpty()) {
            throw new IllegalArgumentException("Not support operation: " + method);
        }
        this.attributes.add(new Attribute(name, value, operation));
    }

    protected String operationConvert(String method) {
        return operationMap.get(method);
    }
}

