/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.asynccollector;

import com.datarangers.asynccollector.CollectorContainer;
import com.datarangers.collector.Collector;
import com.datarangers.config.Constants;
import com.datarangers.config.RangersJSONConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.HashMap;

public class CollectorCounter
implements Runnable {
    private String countName;

    public CollectorCounter(String savePath) {
        this.countName = savePath + "/count.log";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        File output = new File(this.countName);
        if (!output.exists()) {
            try {
                output.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileOutputStream stream = null;
        try {
            stream = new FileOutputStream(output, true);
            HashMap<String, Object> status = new HashMap<String, Object>(2){
                {
                    this.put("history", CollectorContainer.SEND_HISTORY);
                    this.put("queue_length", Collector.collectorContainer.size());
                }
            };
            stream.write((LocalDateTime.now().format(Constants.FULL_DAY) + " " + RangersJSONConfig.getInstance().toJson(status) + "\n").getBytes());
            stream.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

