/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.collector;

import com.datarangers.asynccollector.CollectorContainer;
import com.datarangers.asynccollector.CollectorCounter;
import com.datarangers.asynccollector.CollectorQueue;
import com.datarangers.asynccollector.Consumer;
import com.datarangers.asynccollector.RangersCollectorQueue;
import com.datarangers.collector.EventCollector;
import com.datarangers.config.DataRangersSDKConfigProperties;
import com.datarangers.config.EventConfig;
import com.datarangers.config.HttpConfig;
import com.datarangers.config.KafkaConfig;
import com.datarangers.config.RangersJSONConfig;
import com.datarangers.config.SdkMode;
import com.datarangers.logger.RangersFileCleaner;
import com.datarangers.message.AppMessage;
import com.datarangers.message.Message;
import com.datarangers.message.MessageEnv;
import com.datarangers.sender.Callback;
import com.datarangers.sender.VerifySender;
import com.datarangers.sender.callback.LoggingCallback;
import com.datarangers.util.HttpUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Collector
implements EventCollector {
    private String appType;
    public static final Logger logger = LoggerFactory.getLogger((String)"DatarangersLog");
    public static ExecutorService executorService = null;
    public static ScheduledExecutorService scheduled = null;
    public static CollectorContainer collectorContainer;
    public static VerifySender verifySender;
    private boolean enable;
    protected DataRangersSDKConfigProperties properties;
    protected Callback callback;
    protected Consumer consumer = null;
    protected static KafkaProducer kafkaProducer;
    private static volatile Boolean IS_INIT;

    public Collector(String appType, DataRangersSDKConfigProperties properties, Callback cb) {
        this.appType = appType;
        this.enable = properties.isEnable();
        this.properties = properties;
        this.callback = cb;
        this.properties.setCallback(this.getCallback());
        this.init();
    }

    public String getAppType() {
        return this.appType;
    }

    public void setAppType(String appType) {
        this.appType = appType;
    }

    public Callback getCallback() {
        return this.callback;
    }

    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public Consumer getConsumer() {
        return this.consumer;
    }

    public void setConsumer(Consumer consumer) {
        this.consumer = consumer;
    }

    private void initModeKafka() {
        if (SdkMode.KAFKA != this.properties.getMode()) {
            return;
        }
        logger.info("init kafka producer");
        if (kafkaProducer != null) {
            return;
        }
        kafkaProducer = this.createProducer(this.properties.getKafka());
    }

    private KafkaProducer<String, String> createProducer(KafkaConfig kafkaConfig) {
        Properties props = new Properties();
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("bootstrap.servers", kafkaConfig.getBootstrapServers());
        Map<String, Object> map = kafkaConfig.getProperties();
        if (map != null && !map.isEmpty()) {
            props.putAll(map);
        }
        return new KafkaProducer(props);
    }

    public void send(Message message) {
        this.sendMessage(message);
    }

    private void sendMessage(Message message) {
        if (!this.enable) {
            return;
        }
        message.merge();
        this.validate(message);
        this.sendToVerify(message);
        if (kafkaProducer != null) {
            this.sendByKafka(message.getAppMessage());
            return;
        }
        String sendMessage = RangersJSONConfig.getInstance().toJson(message.getAppMessage());
        if (this.properties.isSync()) {
            this.syncSendMessage(message, sendMessage);
        } else {
            this.asyncSendMessage(message, sendMessage);
        }
    }

    private void sendToVerify(Message message) {
        verifySender.send(message);
    }

    private void sendByKafka(AppMessage appMessage) {
        appMessage.getHeader().setSource("sdk_server");
        final String sendMessage = RangersJSONConfig.getInstance().toJson(appMessage);
        try {
            ProducerRecord producerRecord = new ProducerRecord(this.properties.getKafka().getTopic(), (Object)sendMessage);
            kafkaProducer.send(producerRecord, new org.apache.kafka.clients.producer.Callback(){

                public void onCompletion(RecordMetadata recordMetadata, Exception e) {
                    if (e != null) {
                        logger.error(String.format("kafka send message error. value: \r\n %s", sendMessage), (Throwable)e);
                        Collector.this.getCallback().onFailed(new Callback.FailedData(sendMessage, e.getMessage(), e, false));
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(String.format("kafka send message error. value: \r\n %s", sendMessage), (Throwable)e);
            this.getCallback().onFailed(new Callback.FailedData(sendMessage, e.getMessage(), e, false));
        }
    }

    private void syncSendMessage(Message message, String sendMessage) {
        try {
            this.consumer.flush(message);
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("sync send message error", (Throwable)e);
            this.getCallback().onFailed(new Callback.FailedData(sendMessage, e.getMessage(), e, false));
        }
    }

    private void asyncSendMessage(Message message, String sendMessage) {
        if (collectorContainer.getMessageQueue() != null) {
            try {
                collectorContainer.produce(message);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.error("async send message error", (Throwable)e);
                this.getCallback().onFailed(new Callback.FailedData(sendMessage, e.getMessage(), e, false));
            }
        } else {
            logger.error("getMessageQueue is null");
            this.getCallback().onFailed(new Callback.FailedData(sendMessage, "getMessageQueue is null", false));
        }
    }

    private void validate(Message message) {
        if (!Arrays.asList(MessageEnv.SAAS, MessageEnv.SAAS_NATIVE).contains((Object)this.properties.getMessageEnv())) {
            return;
        }
        Integer appId = message.getAppMessage().getAppId();
        Map<Integer, String> appKeys = this.properties.getAppKeys();
        String appKey = appKeys.get(appId);
        if (appKey == null) {
            throw new IllegalArgumentException("App key cannot be empty. app_id: " + appId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void init() {
        if (IS_INIT.booleanValue()) return;
        Class<Collector> clazz = Collector.class;
        synchronized (Collector.class) {
            if (IS_INIT.booleanValue()) return;
            this.initCommon();
            this.initLogger();
            this.initSdkMode();
            this.initConsumer();
            this.initHook();
            this.initVerifySender();
            IS_INIT = true;
            logger.info("sdk config properties: \r\n{}", (Object)this.properties);
            System.out.println("sdk config properties: \r\n" + this.properties);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private void initVerifySender() {
        verifySender = new VerifySender(this.properties.getVerify());
    }

    private void initSdkMode() {
        this.initModeFile();
        this.initModeHttp();
        this.initModeKafka();
    }

    private void initLogger() {
        logger.info("init log writer pool");
        String eventSaveName = this.properties.getEventSaveName();
        int eventSaveMaxFileSize = this.properties.getEventSaveMaxFileSize();
        String eventSavePath = this.properties.getEventSavePath();
        scheduled = Executors.newSingleThreadScheduledExecutor();
        if (!this.properties.isEventCountFileDisable()) {
            scheduled.scheduleAtFixedRate(new CollectorCounter(eventSavePath), 1L, 2L, TimeUnit.MINUTES);
        }
        if (this.properties.getCallback() == null) {
            this.properties.setCallback(new LoggingCallback(eventSavePath, "error-" + eventSaveName, eventSaveMaxFileSize));
        }
    }

    private void initCommon() {
        CollectorQueue userQueue = this.properties.getUserQueue();
        collectorContainer = userQueue == null ? new CollectorContainer(RangersCollectorQueue.getInstance(this.properties.getQueueSize())) : new CollectorContainer(userQueue);
    }

    private void initConsumer() {
        logger.info("init consumer");
        boolean isSync = this.properties.isSync();
        if (isSync) {
            this.setConsumer(new Consumer(collectorContainer, this.properties));
            return;
        }
        if (executorService == null) {
            int threadCount = this.properties.getThreadCount();
            executorService = Executors.newFixedThreadPool(threadCount);
            for (int i = 0; i < threadCount; ++i) {
                executorService.execute(new Consumer(collectorContainer, this.properties));
            }
        }
    }

    private void initModeHttp() {
        if (SdkMode.HTTP != this.properties.getMode()) {
            return;
        }
        HttpConfig httpConfig = this.properties.getHttpConfig();
        HttpClient httpClient = this.properties.getCustomHttpClient();
        Callback callback = this.properties.getCallback();
        int httpTimeOut = this.properties.getHttpTimeout();
        EventConfig.setUrl(this.properties.getDomain());
        if (httpConfig.getMaxPerRoute() < this.properties.getThreadCount()) {
            httpConfig.setMaxPerRoute(this.properties.getThreadCount());
        }
        if (httpConfig.getMaxTotal() < httpConfig.getMaxPerRoute()) {
            httpConfig.setMaxTotal(httpConfig.getMaxPerRoute());
        }
        httpConfig.initTimeOut(httpTimeOut);
        HttpUtils.createHttpClient(httpConfig, httpClient, callback);
        if (EventConfig.SEND_HEADER == null) {
            EventConfig.SEND_HEADER = this.properties.getHeaders();
            EventConfig.SEND_HEADER.put("User-Agent", "DataRangers Java SDK");
            EventConfig.SEND_HEADER.put("Content-Type", "application/json");
            ArrayList headerList = new ArrayList();
            EventConfig.SEND_HEADER.forEach((key, value) -> headerList.add(new BasicHeader(key, value)));
            EventConfig.headers = headerList.toArray(new Header[0]);
        }
    }

    private void initModeFile() {
        if (SdkMode.FILE != this.properties.getMode()) {
            return;
        }
        this.properties.setThreadCount(1);
        List<String> eventFilePaths = this.properties.getEventFilePaths();
        String eventSaveName = this.properties.getEventSaveName();
        int eventSaveMaxDays = this.properties.getEventSaveMaxDays();
        int eventSaveMaxFileSize = this.properties.getEventSaveMaxFileSize();
        Consumer.setWriterPool(eventFilePaths, eventSaveName, eventSaveMaxFileSize);
        if (eventSaveMaxDays > 0) {
            scheduled.scheduleAtFixedRate(new RangersFileCleaner(eventFilePaths, eventSaveName, eventSaveMaxDays), 0L, 12L, TimeUnit.HOURS);
            logger.info("Start DataRangers Cleaner/Record Thread");
        }
    }

    private void initHook() {
        logger.info("init hook");
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (executorService != null) {
                executorService.shutdown();
            }
            new Consumer(collectorContainer, this.properties).flush();
        }));
    }

    static {
        IS_INIT = false;
    }
}

