/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.config;

import com.datarangers.util.Tools;

public class HttpConfig {
    private Integer maxTotal = 1000;
    private Integer maxPerRoute = 100;
    private Integer requestTimeout = 10000;
    private Integer connectTimeout = 10000;
    private Integer socketTimeout = 20000;
    private Integer keepAliveTimeout = 30;
    private Integer retryCount = 1;
    private boolean customKeyTrustEnable;
    private String keyMaterialPath;
    private String keyPassword;
    private String storePassword;
    private String trustMaterialPath;
    private String trustStrategy;
    private boolean trustDisable;

    public Integer getRequestTimeout() {
        return this.requestTimeout;
    }

    public void setRequestTimeout(Integer requestTimeout) {
        this.requestTimeout = requestTimeout;
    }

    public Integer getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(Integer connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Integer getSocketTimeout() {
        return this.socketTimeout;
    }

    public void setSocketTimeout(Integer socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public boolean isCustomKeyTrustEnable() {
        return this.customKeyTrustEnable;
    }

    public void setCustomKeyTrustEnable(boolean customKeyTrustEnable) {
        this.customKeyTrustEnable = customKeyTrustEnable;
    }

    public String getKeyMaterialPath() {
        return this.keyMaterialPath;
    }

    public void setKeyMaterialPath(String keyMaterialPath) {
        this.keyMaterialPath = keyMaterialPath;
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public void setKeyPassword(String keyPassword) {
        this.keyPassword = keyPassword;
    }

    public String getStorePassword() {
        return this.storePassword;
    }

    public void setStorePassword(String storePassword) {
        this.storePassword = storePassword;
    }

    public String getTrustMaterialPath() {
        return this.trustMaterialPath;
    }

    public void setTrustMaterialPath(String trustMaterialPath) {
        this.trustMaterialPath = trustMaterialPath;
    }

    public String getTrustStrategy() {
        return this.trustStrategy;
    }

    public void setTrustStrategy(String trustStrategy) {
        this.trustStrategy = trustStrategy;
    }

    public boolean isTrustDisable() {
        return this.trustDisable;
    }

    public void setTrustDisable(boolean trustDisable) {
        this.trustDisable = trustDisable;
    }

    @Deprecated
    public void initTimeOut(int timeBase) {
        if (this.requestTimeout == null) {
            this.requestTimeout = timeBase;
        }
        if (this.connectTimeout == null) {
            this.connectTimeout = timeBase;
        }
        if (this.socketTimeout == null) {
            this.socketTimeout = timeBase * 2;
        }
        if (this.keepAliveTimeout == null) {
            this.keepAliveTimeout = 30;
        }
    }

    public Integer getMaxTotal() {
        return this.maxTotal;
    }

    public void setMaxTotal(Integer maxTotal) {
        this.maxTotal = maxTotal;
    }

    public Integer getMaxPerRoute() {
        return this.maxPerRoute;
    }

    public void setMaxPerRoute(Integer maxPerRoute) {
        this.maxPerRoute = maxPerRoute;
    }

    public Integer getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(Integer keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public Integer getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(Integer retryCount) {
        this.retryCount = retryCount;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        sb.append(String.format("\"requestTimeout\": %s,", this.requestTimeout));
        sb.append(String.format("\"connectTimeout\": %s,", this.connectTimeout));
        sb.append(String.format("\"socketTimeout\": %s,", this.socketTimeout));
        sb.append(String.format("\"keepAliveTimeout\": %s,", this.keepAliveTimeout));
        sb.append(String.format("\"retryCount\": %s,", this.retryCount));
        sb.append(String.format("\"maxTotal\": %s,", this.maxTotal));
        sb.append(String.format("\"maxPerRoute\": %s,", this.maxPerRoute));
        sb.append(String.format("\"keyMaterialPath\": \"%s\",", this.keyMaterialPath));
        sb.append(String.format("\"keyPassword\": \"%s\",", Tools.passwordMask(this.keyPassword)));
        sb.append(String.format("\"trustMaterialPath\": \"%s\",", this.trustMaterialPath));
        sb.append(String.format("\"storePassword\": \"%s\"", Tools.passwordMask(this.storePassword)));
        sb.append("}");
        return sb.toString();
    }
}

