/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.message.saas;

import com.datarangers.event.Event;
import com.datarangers.event.EventV3;
import com.datarangers.event.HeaderV3;
import com.datarangers.event.SaasServerEvent;
import com.datarangers.event.User;
import com.datarangers.message.AppMessage;
import com.datarangers.message.Message;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class DefaultSaasServerAppMessage {
    @JsonProperty(value="user")
    private User user = new User();
    @JsonProperty(value="header")
    private HeaderV3 header = (HeaderV3)new HeaderV3.Builder().build();
    @JsonProperty(value="events")
    private List<SaasServerEvent> events = new ArrayList<SaasServerEvent>();

    public DefaultSaasServerAppMessage(Message message) {
        AppMessage appMessage = message.getAppMessage();
        this.getUser().setUserUniqueId(appMessage.getUserUniqueId());
        this.setHeader(appMessage.getHeader());
        List<Event> appEvents = appMessage.getEvents();
        if (appEvents != null) {
            this.events.addAll(appEvents.stream().map(n -> new SaasServerEvent((EventV3)n)).collect(Collectors.toList()));
        }
    }

    public User getUser() {
        return this.user;
    }

    public void setUser(User user) {
        this.user = user;
    }

    public HeaderV3 getHeader() {
        return this.header;
    }

    public void setHeader(HeaderV3 header) {
        this.header = header;
    }

    public List<SaasServerEvent> getEvents() {
        return this.events;
    }

    public void setEvents(List<SaasServerEvent> events) {
        this.events = events;
    }
}

