/*
 * Decompiled with CFR 0.152.
 */
package com.datarangers.util;

import com.datarangers.config.HttpConfig;
import com.datarangers.config.RangersJSONConfig;
import com.datarangers.sender.Callback;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.classic.methods.HttpUriRequestBase;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultHttpRequestRetryStrategy;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.socket.LayeredConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.TrustAllStrategy;
import org.apache.hc.client5.http.ssl.TrustSelfSignedStrategy;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.ssl.SSLContextBuilder;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.ssl.TrustStrategy;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtils {
    public static final Logger logger = LoggerFactory.getLogger(HttpUtils.class);
    private static Callback callback = null;
    private static HttpClient httpClient = null;
    private static volatile Boolean initFlag = false;
    private static Integer retryCount;

    public static HttpClient getHttpClient() {
        if (!initFlag.booleanValue()) {
            throw new IllegalArgumentException("Not init httpclient");
        }
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createHttpClient(HttpConfig httpConfig, HttpClient customHttpClient, Callback callback) {
        if (!initFlag.booleanValue()) {
            Boolean bl = initFlag;
            synchronized (bl) {
                if (!initFlag.booleanValue()) {
                    if (httpClient == null) {
                        if (customHttpClient != null) {
                            httpClient = customHttpClient;
                        } else {
                            SSLContext sslContext = HttpUtils.createSSLContext(httpConfig);
                            SSLConnectionSocketFactory sslSocketFactory = httpConfig.isTrustDisable() ? new SSLConnectionSocketFactory(sslContext, (s, sslSession) -> true) : SSLConnectionSocketFactory.getSocketFactory();
                            PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setMaxConnTotal(httpConfig.getMaxTotal().intValue()).setMaxConnPerRoute(httpConfig.getMaxPerRoute().intValue()).setSSLSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory).build();
                            RequestConfig requestConfig = RequestConfig.custom().setConnectionRequestTimeout(Timeout.ofMicroseconds((long)httpConfig.getRequestTimeout().intValue())).setConnectTimeout(Timeout.ofMilliseconds((long)httpConfig.getConnectTimeout().intValue())).setResponseTimeout(Timeout.ofMilliseconds((long)httpConfig.getSocketTimeout().intValue())).setConnectionKeepAlive(TimeValue.ofSeconds((long)httpConfig.getKeepAliveTimeout().intValue())).setCookieSpec("easy").build();
                            httpClient = HttpClients.custom().setRetryStrategy((HttpRequestRetryStrategy)new DefaultHttpRequestRetryStrategy(3, TimeValue.ofMilliseconds((long)1000L))).setConnectionManager((HttpClientConnectionManager)cm).setDefaultRequestConfig(requestConfig).build();
                        }
                    }
                    initFlag = true;
                    HttpUtils.callback = callback;
                    retryCount = httpConfig.getRetryCount();
                }
            }
        }
    }

    private static SSLContext createSSLContext(HttpConfig httpConfig) {
        if (httpConfig.isTrustDisable()) {
            SSLContext sslContext = null;
            try {
                sslContext = SSLContext.getInstance("TLS");
                X509TrustManager tm = new X509TrustManager(){

                    @Override
                    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    }

                    @Override
                    public X509Certificate[] getAcceptedIssuers() {
                        return null;
                    }
                };
                sslContext.init(null, new TrustManager[]{tm}, null);
                return sslContext;
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                e.printStackTrace();
                throw new RuntimeException("init ssl error", e);
            }
        }
        if (!httpConfig.isCustomKeyTrustEnable()) {
            return SSLContexts.createDefault();
        }
        SSLContextBuilder sslContextBuilder = SSLContextBuilder.create();
        String keyMaterialPath = httpConfig.getKeyMaterialPath();
        String keyPassword = httpConfig.getKeyPassword();
        String storePassword = httpConfig.getStorePassword();
        String trustMaterialPath = httpConfig.getTrustMaterialPath();
        TrustSelfSignedStrategy trustStrategy = "self".equalsIgnoreCase(httpConfig.getTrustStrategy()) ? new TrustSelfSignedStrategy() : new TrustAllStrategy();
        try {
            sslContextBuilder.loadKeyMaterial(new File(keyMaterialPath), storePassword.toCharArray(), keyPassword.toCharArray());
            sslContextBuilder.loadTrustMaterial(new File(trustMaterialPath), storePassword.toCharArray(), (TrustStrategy)trustStrategy);
            return sslContextBuilder.build();
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            e.printStackTrace();
            throw new RuntimeException("init ssl error", e);
        }
    }

    public static void post(String url, String body, Map<String, String> headers, int count) {
        HttpUtils.request("POST", url, body, headers, count);
    }

    public static void request(String method, String url, String body, Map<String, String> headers) {
        if (body == null) {
            return;
        }
        HttpUtils.request(method, url, body, headers, retryCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void request(String method, String url, String body, Map<String, String> headers, int count) {
        HttpUriRequestBase httpRequest = new HttpUriRequestBase(method.toUpperCase(), URI.create(url));
        logger.debug(body);
        CloseableHttpResponse response = null;
        String requestId = HttpUtils.getXRequestID();
        String resultStr = null;
        try {
            StringEntity entity = new StringEntity(body, ContentType.APPLICATION_JSON);
            httpRequest.addHeader((Header)new BasicHeader("X-Request-ID", (Object)requestId));
            if (headers != null) {
                headers.entrySet().stream().forEach(entry -> httpRequest.addHeader((Header)new BasicHeader((String)entry.getKey(), entry.getValue())));
            }
            httpRequest.setEntity((HttpEntity)entity);
            response = (CloseableHttpResponse)httpClient.execute((ClassicHttpRequest)httpRequest);
            resultStr = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            if (!HttpUtils.isSuccess(response, resultStr)) {
                String causeMsg = String.format("HTTP ERROR, code: %s, resultStr: %s", response.getCode(), resultStr);
                logger.error(causeMsg);
                logger.error("request error: requestId={}, method={}, url={}, body={},header={}", new Object[]{requestId, method, url, body, headers});
                callback.onFailed(new Callback.FailedData(body, causeMsg, HttpUtils.isListable(url)));
            }
        }
        catch (IOException e) {
            if (count > 2) {
                logger.error(String.format("request error, io error: %s, resultStr: %s", e.getMessage(), resultStr), (Throwable)e);
                callback.onFailed(new Callback.FailedData(body, e.toString(), e, HttpUtils.isListable(url)));
            } else {
                HttpUtils.post(url, body, headers, ++count);
            }
        }
        catch (ParseException e) {
            logger.error("request error, parse error: requestId={}, method={}, url={}, body={},header={}", new Object[]{requestId, method, url, body, headers});
            callback.onFailed(new Callback.FailedData(body, e.toString(), (Exception)((Object)e), HttpUtils.isListable(url)));
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException e) {
                logger.error(e.toString(), (Throwable)e);
            }
        }
    }

    public static void post(String url, String body, Map<String, String> headers) {
        if (body == null) {
            return;
        }
        HttpUtils.post(url, body, headers, retryCount);
    }

    public static String getXRequestID() {
        return UUID.randomUUID().toString().replaceAll("-", String.valueOf(new SecureRandom().nextInt(10)));
    }

    private static boolean isSuccess(CloseableHttpResponse response, String resultStr) throws IOException {
        if (200 != response.getCode()) {
            return false;
        }
        Map object = RangersJSONConfig.getInstance().fromJson(resultStr, Map.class);
        if (object != null && (object.containsKey("message") && "success".equals(object.get("message").toString()) || object.containsKey("responses"))) {
            logger.debug("Send Success.");
            logger.debug(resultStr);
            return true;
        }
        return false;
    }

    private static boolean isListable(String url) {
        return url.endsWith("/sdk/list");
    }
}

