/*
 * Decompiled with CFR 0.152.
 */
package jj2000.j2k.quantization;

import com.github.jaiimageio.jpeg2000.impl.J2KImageWriteParamJava;
import java.util.StringTokenizer;
import jj2000.j2k.ModuleSpec;

public class GuardBitsSpec
extends ModuleSpec {
    private String defaultValue = "2";

    public GuardBitsSpec(int nt, int nc, byte type) {
        super(nt, nc, type);
    }

    public GuardBitsSpec(int nt, int nc, byte type, J2KImageWriteParamJava wp, String values) {
        super(nt, nc, type);
        if (values == null) {
            this.setDefault(new Integer(this.defaultValue));
            return;
        }
        String param = values;
        StringTokenizer stk = new StringTokenizer(param);
        int curSpecType = 0;
        boolean[] tileSpec = null;
        boolean[] compSpec = null;
        block11: while (stk.hasMoreTokens()) {
            int i;
            Integer value;
            String word = stk.nextToken().toLowerCase();
            switch (word.charAt(0)) {
                case 't': {
                    tileSpec = GuardBitsSpec.parseIdx(word, this.nTiles);
                    if (curSpecType == 1) {
                        curSpecType = 3;
                        continue block11;
                    }
                    curSpecType = 2;
                    continue block11;
                }
                case 'c': {
                    compSpec = GuardBitsSpec.parseIdx(word, this.nComp);
                    if (curSpecType == 2) {
                        curSpecType = 3;
                        continue block11;
                    }
                    curSpecType = 1;
                    continue block11;
                }
            }
            try {
                value = new Integer(word);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bad parameter for -Qguard_bits option : " + word);
            }
            if (value.floatValue() <= 0.0f) {
                throw new IllegalArgumentException("Guard bits value must be positive : " + value);
            }
            if (curSpecType == 0) {
                this.setDefault(value);
            } else if (curSpecType == 2) {
                for (i = tileSpec.length - 1; i >= 0; --i) {
                    if (!tileSpec[i]) continue;
                    this.setTileDef(i, value);
                }
            } else if (curSpecType == 1) {
                for (i = compSpec.length - 1; i >= 0; --i) {
                    if (!compSpec[i]) continue;
                    this.setCompDef(i, value);
                }
            } else {
                for (i = tileSpec.length - 1; i >= 0; --i) {
                    for (int j = compSpec.length - 1; j >= 0; --j) {
                        if (!tileSpec[i] || !compSpec[j]) continue;
                        this.setTileCompVal(i, j, value);
                    }
                }
            }
            curSpecType = 0;
            tileSpec = null;
            compSpec = null;
        }
        if (this.getDefault() == null) {
            int t;
            int ndefspec = 0;
            for (t = nt - 1; t >= 0; --t) {
                for (int c = nc - 1; c >= 0; --c) {
                    if (this.specValType[t][c] != 0) continue;
                    ++ndefspec;
                }
            }
            if (ndefspec != 0) {
                this.setDefault(new Integer(this.defaultValue));
            } else {
                this.setDefault(this.getTileCompVal(0, 0));
                switch (this.specValType[0][0]) {
                    case 2: {
                        for (int c = nc - 1; c >= 0; --c) {
                            if (this.specValType[0][c] != 2) continue;
                            this.specValType[0][c] = 0;
                        }
                        this.tileDef[0] = null;
                        break;
                    }
                    case 1: {
                        for (t = nt - 1; t >= 0; --t) {
                            if (this.specValType[t][0] != 1) continue;
                            this.specValType[t][0] = 0;
                        }
                        this.compDef[0] = null;
                        break;
                    }
                    case 3: {
                        this.specValType[0][0] = 0;
                        this.tileCompVal.put("t0c0", null);
                    }
                }
            }
        }
    }
}

