/*
 * Decompiled with CFR 0.152.
 */
package com.tuples;

import com.tuples.Action;
import com.tuples.Converts;
import com.tuples.ITuple;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class Tuple
implements ITuple {
    private List<Object> values;
    private List<String> names = new LinkedList<String>();

    public Tuple() {
        this.values = new ArrayList<Object>();
    }

    public Tuple(int initialCapacity) {
        this.values = new ArrayList<Object>(initialCapacity);
    }

    public Tuple(Tuple otherTuple) {
        this.values = new ArrayList<Object>(otherTuple.values.size() + 8);
        this.values.addAll(otherTuple.values);
        this.names.addAll(otherTuple.names);
    }

    @Override
    public int size() {
        return this.values.size();
    }

    @Override
    public boolean contains(String name) {
        return this.names.contains(name);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values.contains(value);
    }

    @Override
    public Object getValue(int index) {
        return this.values.get(index);
    }

    @Override
    public Object getValue(String name) {
        if (name == null) {
            throw new IllegalArgumentException("not contains empty or null name.");
        }
        int index = this.names.indexOf(name);
        if (index < 0) {
            return null;
        }
        return this.values.get(index);
    }

    @Override
    public byte[] getBytes(int index) {
        return Converts.asBytes(this.getValue(index));
    }

    @Override
    public byte[] getBytes(String name) {
        return Converts.asBytes(this.getValue(name));
    }

    @Override
    public Character getChar(int index) {
        return Converts.asCharacter(this.getValue(index));
    }

    @Override
    public Character getChar(String name) {
        return Converts.asCharacter(this.getValue(name));
    }

    @Override
    public Boolean getBoolean(int index) {
        return Converts.asBoolean(this.getValue(index));
    }

    @Override
    public Boolean getBoolean(String name) {
        return Converts.asBoolean(this.getValue(name));
    }

    @Override
    public Byte getByte(int index) {
        return Converts.asByte(this.getValue(index));
    }

    @Override
    public Byte getByte(String name) {
        return Converts.asByte(this.getValue(name));
    }

    @Override
    public Short getShort(int index) {
        return Converts.asShort(this.getValue(index));
    }

    @Override
    public Short getShort(String name) {
        return Converts.asShort(this.getValue(name));
    }

    @Override
    public Integer getInt(int index) {
        return Converts.asInteger(this.getValue(index));
    }

    @Override
    public Integer getInt(String name) {
        return Converts.asInteger(this.getValue(name));
    }

    @Override
    public Long getLong(int index) {
        return Converts.asLong(this.getValue(index));
    }

    @Override
    public Long getLong(String name) {
        return Converts.asLong(this.getValue(name));
    }

    @Override
    public Float getFloat(int index) {
        return Converts.asFloat(this.getValue(index));
    }

    @Override
    public Float getFloat(String name) {
        return Converts.asFloat(this.getValue(name));
    }

    @Override
    public Double getDouble(int index) {
        return Converts.asDouble(this.getValue(index));
    }

    @Override
    public Double getDouble(String name) {
        return Converts.asDouble(this.getValue(name));
    }

    @Override
    public BigDecimal getBigDecimal(int index) {
        return Converts.asBigDecimal(this.getValue(index));
    }

    @Override
    public BigDecimal getBigDecimal(String name) {
        return Converts.asBigDecimal(this.getValue(name));
    }

    @Override
    public String getString(int index) {
        return Converts.asString(this.getValue(index));
    }

    @Override
    public String getString(String name) {
        return Converts.asString(this.getValue(name));
    }

    @Override
    public List<Object> getValues() {
        LinkedList<Object> result = new LinkedList<Object>();
        Collections.copy(result, this.values);
        return result;
    }

    @Override
    public void add(Object value) {
        this.values.add(value);
        this.names.add(null);
    }

    @Override
    public void add(int index, Object value) {
        this.values.add(index, value);
        this.names.add(index, null);
    }

    @Override
    public void add(String name, Object value) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        int index = this.names.indexOf(name);
        if (index > -1) {
            this.names.remove(index);
            this.values.remove(index);
        }
        this.values.add(value);
        this.names.add(name);
    }

    @Override
    public boolean remove(Object value) {
        int index = this.values.indexOf(value);
        boolean result = this.values.remove(value);
        if (result) {
            this.names.remove(index);
        }
        return result;
    }

    @Override
    public Object removeName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name cannot be null.");
        }
        int index = this.names.indexOf(name);
        if (index >= 0) {
            return this.values.remove(index);
        }
        return null;
    }

    @Override
    public Object removeIndex(int index) {
        Object result = this.values.remove(index);
        this.names.remove(index);
        return result;
    }

    @Override
    public void forEach(Action<String, Integer, Object> action) {
        if (action == null) {
            return;
        }
        int len = this.values.size();
        for (int i = 0; i < len; ++i) {
            action.apply(this.names.get(i), i, this.values.get(i));
        }
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("[");
        int limit = this.size() - 1;
        this.forEach((name, index, value) -> {
            result.append("{");
            if (name != null) {
                result.append("\"").append((String)name).append("\"");
            } else {
                result.append(index);
            }
            result.append(":").append(value).append("}");
            if (index < limit) {
                result.append(",");
            }
        });
        result.append("]");
        return result.toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Tuple other = (Tuple)obj;
        return this.values.equals(other.values) && this.names.equals(other.names);
    }
}

