/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.Cell;
import com.github.liaochong.myexcel.core.ExcelColumnMapping;
import com.github.liaochong.myexcel.core.ReadContext;
import com.github.liaochong.myexcel.core.Row;
import com.github.liaochong.myexcel.core.RowContext;
import com.github.liaochong.myexcel.core.SaxExcelReader;
import com.github.liaochong.myexcel.core.annotation.ExcelColumn;
import com.github.liaochong.myexcel.core.annotation.MultiColumn;
import com.github.liaochong.myexcel.core.converter.ConvertContext;
import com.github.liaochong.myexcel.core.converter.ReadConverterContext;
import com.github.liaochong.myexcel.core.reflect.ClassFieldContainer;
import com.github.liaochong.myexcel.exception.StopReadException;
import com.github.liaochong.myexcel.utils.ConfigurationUtil;
import com.github.liaochong.myexcel.utils.FieldDefinition;
import com.github.liaochong.myexcel.utils.ReflectUtil;
import com.github.liaochong.myexcel.utils.StringUtil;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.poi.ss.util.CellAddress;

abstract class AbstractReadHandler<T> {
    private Map<Integer, FieldDefinition> fieldDefinitionMap;
    private T obj;
    protected Map<Integer, Map<Integer, String>> titles = new LinkedHashMap<Integer, Map<Integer, String>>();
    protected SaxExcelReader.ReadConfig<T> readConfig;
    private final ReadContext<T> context = new ReadContext();
    private final RowContext rowContext = new RowContext();
    private final ConvertContext convertContext;
    private final Row currentRow = new Row(-1);
    private int prevColNum = -1;
    private Supplier<T> newInstance;
    private BiConsumer<Integer, String> fieldHandler;
    private Consumer<T> resultHandler;
    private BiConsumer<T, RowContext> contextResultHandler;
    private boolean readWithTitle;
    private int titleRowNum = -1;
    protected boolean isBlankRow;
    protected Map<CellAddress, CellAddress> mergeCellMapping;
    private final boolean isMapType;
    private final Map<Class<?>, Integer> fieldParentIndexMapping;

    public AbstractReadHandler(boolean readCsv, List<T> result, SaxExcelReader.ReadConfig<T> readConfig, Map<CellAddress, CellAddress> mergeCellMapping) {
        this.mergeCellMapping = mergeCellMapping;
        this.convertContext = new ConvertContext(readCsv);
        Class dataType = readConfig.dataType;
        this.fieldDefinitionMap = ReflectUtil.getFieldDefinitionMapOfExcelColumn(dataType);
        this.readConfig = readConfig;
        this.isMapType = dataType == Map.class;
        this.readWithTitle = !this.isMapType && this.fieldDefinitionMap.isEmpty();
        this.setNewInstanceFunction(dataType, this.isMapType);
        this.setConfiguration(dataType, this.isMapType);
        this.setResultHandlerFunction(result, readConfig);
        this.setFieldHandlerFunction();
        this.fieldParentIndexMapping = this.fieldDefinitionMap.values().stream().map(f -> f.getField().getDeclaringClass()).distinct().collect(Collectors.toMap(c -> c, c -> 9999999));
    }

    private void setResultHandlerFunction(List<T> result, SaxExcelReader.ReadConfig<T> readConfig) {
        if (readConfig.consumer != null) {
            this.resultHandler = v -> readConfig.consumer.accept(v);
        } else if (readConfig.function != null) {
            this.resultHandler = v -> {
                Boolean noStop = readConfig.function.apply(v);
                if (!noStop.booleanValue()) {
                    throw new StopReadException();
                }
            };
        } else if (readConfig.contextConsumer != null) {
            this.contextResultHandler = (v, context) -> readConfig.contextConsumer.accept(v, (RowContext)context);
        } else if (readConfig.contextFunction != null) {
            this.contextResultHandler = (v, context) -> {
                Boolean noStop = readConfig.contextFunction.apply(v, (RowContext)context);
                if (!noStop.booleanValue()) {
                    throw new StopReadException();
                }
            };
        } else {
            this.resultHandler = result::add;
        }
    }

    private void setNewInstanceFunction(Class<T> dataType, boolean isMapType) {
        this.newInstance = isMapType ? () -> new LinkedHashMap() : () -> ReflectUtil.newInstance(dataType);
    }

    private void setConfiguration(Class<T> dataType, boolean isMapType) {
        if (isMapType) {
            return;
        }
        ClassFieldContainer classFieldContainer = ReflectUtil.getAllFieldsOfClass(dataType);
        ConfigurationUtil.parseConfiguration(classFieldContainer, this.convertContext.configuration);
        List<Field> fields = classFieldContainer.getFieldsByAnnotation(ExcelColumn.class);
        fields.forEach(field -> {
            ExcelColumn excelColumn = field.getAnnotation(ExcelColumn.class);
            if (excelColumn == null) {
                return;
            }
            ExcelColumnMapping mapping = ExcelColumnMapping.mapping(excelColumn);
            this.convertContext.excelColumnMappingMap.put((Field)field, mapping);
        });
    }

    protected void setFieldHandlerFunction() {
        this.fieldHandler = this.isMapType ? (colNum, content) -> {
            for (int i = this.prevColNum + 1; i < colNum; ++i) {
                ((Map)this.obj).put(new Cell(this.currentRow.getRowNum(), i), null);
            }
            ((Map)this.obj).put(new Cell(this.currentRow.getRowNum(), (int)colNum), content);
            this.prevColNum = colNum;
        } : (this.mergeCellMapping.isEmpty() ? (colNum, content) -> {
            FieldDefinition fieldDefinition = this.fieldDefinitionMap.get(colNum);
            if (fieldDefinition != null) {
                this.convert((String)content, this.currentRow.getRowNum(), (int)colNum, fieldDefinition.getField());
            }
        } : (colNum, content) -> {
            boolean isList;
            FieldDefinition fieldDefinition = this.fieldDefinitionMap.get(colNum);
            if (fieldDefinition == null) {
                return;
            }
            CellAddress cellAddress = new CellAddress(this.currentRow.getRowNum(), colNum.intValue());
            CellAddress target = this.mergeCellMapping.get(cellAddress);
            boolean bl = isList = fieldDefinition.getField().getType() == List.class;
            if (!isList && fieldDefinition.getParentFields().isEmpty()) {
                if (target == null) {
                    this.convert((String)content, this.currentRow.getRowNum(), (int)colNum, fieldDefinition.getField());
                }
            } else {
                try {
                    Object prevObj = this.obj;
                    int size = fieldDefinition.getParentFields().size();
                    for (int i = 0; i < size - 1; ++i) {
                        Field parentField = fieldDefinition.getParentFields().get(i);
                        List list = (List)parentField.get(prevObj);
                        prevObj = list.get(list.size() - 1);
                    }
                    Field lastField = isList && fieldDefinition.getParentFields().isEmpty() ? fieldDefinition.getField() : fieldDefinition.getParentFields().get(fieldDefinition.getParentFields().size() - 1);
                    Object lastParent = lastField.get(prevObj);
                    if (lastParent == null) {
                        LinkedList list = new LinkedList();
                        lastField.set(prevObj, list);
                        prevObj = list;
                    } else {
                        prevObj = lastParent;
                    }
                    if (target == null) {
                        MultiColumn multiColumn = lastField.getAnnotation(MultiColumn.class);
                        if (isList) {
                            boolean isBase = ReadConverterContext.support(multiColumn.classType());
                            if (((List)prevObj).isEmpty() && !isBase) {
                                Object value = multiColumn.classType().newInstance();
                                ((List)prevObj).add(value);
                            }
                            if (isBase) {
                                this.convert(prevObj, (String)content, this.currentRow.getRowNum(), (int)colNum, fieldDefinition.getField());
                            } else {
                                Object targetParent = ((List)prevObj).get(((List)prevObj).size() - 1);
                                LinkedList targetObj = fieldDefinition.getField().get(targetParent);
                                if (targetObj == null) {
                                    targetObj = new LinkedList();
                                    fieldDefinition.getField().set(targetParent, targetObj);
                                }
                                this.convert(targetObj, (String)content, this.currentRow.getRowNum(), (int)colNum, fieldDefinition.getField());
                            }
                        } else {
                            Object value;
                            if (this.fieldParentIndexMapping.get(fieldDefinition.getField().getDeclaringClass()) >= colNum) {
                                value = multiColumn.classType().newInstance();
                                ((List)prevObj).add(value);
                            } else {
                                value = ((List)prevObj).get(((List)prevObj).size() - 1);
                            }
                            this.convert(value, (String)content, this.currentRow.getRowNum(), (int)colNum, fieldDefinition.getField());
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                this.fieldParentIndexMapping.put(fieldDefinition.getField().getDeclaringClass(), (Integer)colNum);
            }
        });
    }

    protected void convert(Object prevObj, String value, int rowNum, int colNum, Field field) {
        if (value == null || field == null) {
            return;
        }
        this.context.reset(this.obj, field, value, rowNum, colNum);
        ReadConverterContext.convert(prevObj, this.context, this.convertContext, this.readConfig.exceptionFunction);
    }

    protected void convert(String value, int rowNum, int colNum, Field field) {
        if (value == null || field == null) {
            return;
        }
        this.context.reset(this.obj, field, value, rowNum, colNum);
        ReadConverterContext.convert(this.obj, this.context, this.convertContext, this.readConfig.exceptionFunction);
    }

    protected void newRow(int rowNum, boolean newInstance) {
        this.currentRow.setRowNum(rowNum);
        if (this.obj == null || newInstance) {
            this.obj = this.newInstance.get();
        }
        this.prevColNum = -1;
        this.isBlankRow = true;
    }

    protected void setRecordAsNull() {
        this.obj = null;
    }

    protected void handleField(Integer colNum, String content) {
        if (this.obj == null || colNum < 0) {
            return;
        }
        this.isBlankRow = false;
        content = this.readConfig.trim.apply(content);
        if (this.readConfig.rowFilter.test(this.currentRow)) {
            this.fieldHandler.accept(colNum, content);
        } else if (this.readWithTitle) {
            Row nextRow;
            Map rowMapping = this.titles.computeIfAbsent(this.currentRow.getRowNum(), rowNum -> new HashMap());
            rowMapping.put(colNum, content);
            if (this.titleRowNum == -1 && this.readConfig.rowFilter.test(nextRow = new Row(this.currentRow.getRowNum() + 1))) {
                this.titleRowNum = this.currentRow.getRowNum();
            }
        }
    }

    protected void handleResult() {
        if (this.isBlankRow) {
            if (this.readConfig.stopReadingOnBlankRow) {
                throw new StopReadException();
            }
            if (this.readConfig.ignoreBlankRow) {
                return;
            }
        }
        this.initFieldMap();
        if (!this.readConfig.rowFilter.test(this.currentRow)) {
            return;
        }
        if (!this.readConfig.beanFilter.test(this.obj)) {
            return;
        }
        if (this.readWithTitle && this.currentRow.getRowNum() == 0) {
            this.readWithTitle = false;
            return;
        }
        if (this.resultHandler != null) {
            this.resultHandler.accept(this.obj);
        } else {
            this.rowContext.setRowNum(this.currentRow.getRowNum());
            this.contextResultHandler.accept(this.obj, this.rowContext);
        }
    }

    private void initFieldMap() {
        if (this.currentRow.getRowNum() != this.titleRowNum || !this.fieldDefinitionMap.isEmpty()) {
            return;
        }
        Map<String, Field> titleFieldMap = ReflectUtil.getFieldMapOfTitleExcelColumn(this.readConfig.dataType);
        this.fieldDefinitionMap = new HashMap<Integer, FieldDefinition>(titleFieldMap.size());
        List colNums = this.titles.values().stream().flatMap(t -> t.keySet().stream()).collect(Collectors.toList());
        int maxColNum = (Integer)Collections.max(colNums);
        Map<Integer, String> titleMapping = this.titles.get(this.titleRowNum);
        for (int i = 0; i <= maxColNum; ++i) {
            StringJoiner realTitle = new StringJoiner("->");
            int colNum = i;
            this.titles.keySet().forEach(rowNum -> {
                if (rowNum == this.titleRowNum) {
                    return;
                }
                Map<Integer, String> prevColMapping = this.titles.get(rowNum);
                int realColNum = colNum;
                while (true) {
                    String prevTitle;
                    if (StringUtil.isNotBlank(prevTitle = prevColMapping.get(realColNum))) {
                        realTitle.add(prevTitle);
                        return;
                    }
                    --realColNum;
                }
            });
            String title = titleMapping.get(i);
            if (StringUtil.isNotBlank(title)) {
                realTitle.add(title);
            }
            this.fieldDefinitionMap.put(colNum, new FieldDefinition(titleFieldMap.get(realTitle.toString())));
        }
        this.titles = null;
    }
}

