/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.PromptContainer;
import com.github.liaochong.myexcel.core.annotation.ExcelColumn;
import com.github.liaochong.myexcel.core.annotation.Prompt;
import com.github.liaochong.myexcel.core.constant.FileType;
import com.github.liaochong.myexcel.core.constant.LinkType;
import com.github.liaochong.myexcel.core.converter.CustomWriteConverter;
import com.github.liaochong.myexcel.utils.StringUtil;

public final class ExcelColumnMapping {
    public String title;
    public int order;
    public int index;
    public Class<?>[] groups;
    public String defaultValue;
    public int width;
    public boolean convertToString;
    public String format;
    public String[] style;
    public LinkType linkType;
    public String mapping;
    public Class<? extends CustomWriteConverter> customWriteConverter;
    public FileType fileType;
    public boolean formula;
    public PromptContainer promptContainer;

    public static ExcelColumnMapping mapping(ExcelColumn excelColumn) {
        ExcelColumnMapping result = new ExcelColumnMapping();
        result.title = excelColumn.title();
        result.order = excelColumn.order();
        result.index = excelColumn.index();
        result.groups = excelColumn.groups();
        result.defaultValue = excelColumn.defaultValue();
        result.width = excelColumn.width();
        result.convertToString = excelColumn.convertToString();
        result.format = !excelColumn.format().isEmpty() ? excelColumn.format() : (!excelColumn.dateFormatPattern().isEmpty() ? excelColumn.dateFormatPattern() : (!excelColumn.decimalFormat().isEmpty() ? excelColumn.decimalFormat() : ""));
        result.style = excelColumn.style();
        result.linkType = excelColumn.linkType();
        result.mapping = excelColumn.mapping();
        result.fileType = excelColumn.fileType();
        result.formula = excelColumn.formula();
        result.customWriteConverter = excelColumn.writeConverter();
        Prompt prompt = excelColumn.prompt();
        if (StringUtil.isNotBlank(prompt.text())) {
            PromptContainer promptContainer = new PromptContainer();
            promptContainer.title = prompt.title();
            promptContainer.text = prompt.text();
            result.promptContainer = promptContainer;
        }
        return result;
    }
}

