/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractExcelFactory;
import com.github.liaochong.myexcel.core.parser.HtmlTableParser;
import com.github.liaochong.myexcel.core.parser.ParseConfig;
import com.github.liaochong.myexcel.core.parser.Table;
import com.github.liaochong.myexcel.core.parser.Tr;
import com.github.liaochong.myexcel.core.strategy.SheetStrategy;
import com.github.liaochong.myexcel.core.strategy.WidthStrategy;
import com.github.liaochong.myexcel.utils.StringUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlToExcelFactory
extends AbstractExcelFactory {
    private static final Logger log = LoggerFactory.getLogger(HtmlToExcelFactory.class);
    private HtmlTableParser htmlTableParser;

    public static HtmlToExcelFactory readHtml(File htmlFile) throws Exception {
        if (Objects.isNull(htmlFile) || !htmlFile.exists()) {
            throw new NoSuchFileException("html file is not exist");
        }
        HtmlToExcelFactory factory = new HtmlToExcelFactory();
        factory.htmlTableParser = HtmlTableParser.of(htmlFile);
        return factory;
    }

    public static HtmlToExcelFactory readHtml(String html) {
        HtmlToExcelFactory factory = new HtmlToExcelFactory();
        factory.htmlTableParser = HtmlTableParser.of(html);
        return factory;
    }

    public static HtmlToExcelFactory readHtml(File htmlFile, HtmlToExcelFactory htmlToExcelFactory) throws Exception {
        if (Objects.isNull(htmlFile) || !htmlFile.exists()) {
            throw new NoSuchFileException("Html file is not exist");
        }
        if (Objects.isNull(htmlToExcelFactory)) {
            throw new NullPointerException("HtmlToExcelFactory can not be null");
        }
        htmlToExcelFactory.htmlTableParser = HtmlTableParser.of(htmlFile);
        return htmlToExcelFactory;
    }

    public static HtmlToExcelFactory readHtml(String html, HtmlToExcelFactory htmlToExcelFactory) throws Exception {
        if (StringUtil.isBlank(html)) {
            throw new IllegalArgumentException("Html content is empty");
        }
        if (Objects.isNull(htmlToExcelFactory)) {
            throw new NullPointerException("HtmlToExcelFactory can not be null");
        }
        htmlToExcelFactory.htmlTableParser = HtmlTableParser.of(html);
        return htmlToExcelFactory;
    }

    @Override
    public Workbook build() {
        try {
            ParseConfig parseConfig = new ParseConfig(this.widthStrategy);
            List<Table> tables = this.htmlTableParser.getAllTable(parseConfig);
            this.htmlTableParser = null;
            return this.build(tables);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    Workbook build(List<Table> tables, Workbook workbook) {
        if (Objects.nonNull(workbook)) {
            this.workbook = workbook;
        }
        return this.build(tables);
    }

    Workbook build(List<Table> tables) {
        if (Objects.isNull(tables) || tables.isEmpty()) {
            log.warn("There is no any table exist");
            return this.emptyWorkbook();
        }
        log.info("Start build excel");
        long startTime = System.currentTimeMillis();
        if (Objects.isNull(this.workbook)) {
            this.workbook = new XSSFWorkbook();
        }
        this.initCellStyle(this.workbook);
        if (SheetStrategy.isMultiSheet(this.sheetStrategy)) {
            this.buildTablesWithMultiSheet(tables);
        } else {
            this.buildTablesWithOneSheet(tables);
        }
        log.info("Build excel takes {} ms", (Object)(System.currentTimeMillis() - startTime));
        return this.workbook;
    }

    private void buildTablesWithMultiSheet(List<Table> tables) {
        int size = tables.size();
        for (int i = 0; i < size; ++i) {
            boolean hasTd;
            Table table = tables.get(i);
            String sheetName = this.getRealSheetName(table.caption);
            Sheet sheet = this.workbook.getSheet(sheetName);
            if (sheet == null) {
                sheet = this.workbook.createSheet(sheetName);
            }
            if (!(hasTd = table.trList.stream().map(tr -> tr.tdList).anyMatch(list -> !list.isEmpty()))) continue;
            this.setTdOfTable(table, sheet);
            this.freezePane(i, sheet);
            tables.set(i, null);
        }
    }

    private void buildTablesWithOneSheet(List<Table> tables) {
        String sheetName = this.getRealSheetName(tables.get((int)0).caption);
        Sheet sheet = this.workbook.getSheet(sheetName);
        if (sheet == null) {
            sheet = this.workbook.createSheet(sheetName);
        }
        if (tables.size() > 1) {
            List<Tr> trList = tables.get((int)0).trList;
            int lastRowNum = 0;
            if (!trList.isEmpty()) {
                lastRowNum = trList.get((int)(trList.size() - 1)).index;
            }
            for (int i = 1; i < tables.size(); ++i) {
                for (Tr tr2 : tables.get((int)i).trList) {
                    this.updateTrIndex(tr2, ++lastRowNum);
                    trList.add(tr2);
                }
                tables.set(i, null);
            }
        }
        Table table = tables.get(0);
        boolean hasTd = table.trList.stream().map(tr -> tr.tdList).anyMatch(list -> !list.isEmpty());
        if (!hasTd) {
            return;
        }
        this.setTdOfTable(table, sheet);
        this.freezePane(0, sheet);
    }

    private void setTdOfTable(Table table, Sheet sheet) {
        int maxColIndex = 0;
        if (WidthStrategy.isAutoWidth(this.widthStrategy) && !table.trList.isEmpty()) {
            maxColIndex = table.trList.parallelStream().mapToInt(tr -> tr.tdList.stream().mapToInt(td -> td.col).max().orElse(0)).max().orElse(0);
        }
        Map<Integer, Integer> colMaxWidthMap = this.getColMaxWidthMap(table.trList);
        int size = table.trList.size();
        for (int i = 0; i < size; ++i) {
            Tr tr2 = table.trList.get(i);
            this.createRow(tr2, sheet);
            tr2.tdList = null;
        }
        this.stagingTds = new LinkedList();
        table.trList = null;
        this.setColWidth(colMaxWidthMap, sheet, maxColIndex);
    }

    private void updateTrIndex(Tr tr, int sheetLastRowIndex) {
        tr.index = sheetLastRowIndex;
        tr.tdList.forEach(td -> {
            td.row = tr.index;
        });
    }
}

