/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import com.github.liaochong.myexcel.core.AbstractReadHandler;
import com.github.liaochong.myexcel.core.SaxExcelReader;
import com.github.liaochong.myexcel.core.XSSFSheetXMLHandler;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.util.CellAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XSSFSaxReadHandler<T>
extends AbstractReadHandler<T>
implements XSSFSheetXMLHandler.SheetContentsHandler {
    private static final Logger log = LoggerFactory.getLogger(XSSFSaxReadHandler.class);
    private int count;

    public XSSFSaxReadHandler(List<T> result, SaxExcelReader.ReadConfig<T> readConfig, Map<CellAddress, CellAddress> mergeCellMapping) {
        super(false, result, readConfig, mergeCellMapping);
    }

    @Override
    public void startRow(int rowNum, boolean newInstance) {
        this.newRow(rowNum, newInstance);
    }

    @Override
    public void endRow(int rowNum) {
        this.handleResult();
        ++this.count;
    }

    @Override
    public void cell(CellAddress cellAddress, String formattedValue) {
        int thisCol = cellAddress.getColumn();
        this.handleField(thisCol, formattedValue);
    }

    @Override
    public void endSheet() {
        log.info("Import completed, total number of rows {}.", (Object)this.count);
    }
}

