/*
 * Decompiled with CFR 0.152.
 */
package com.github.liaochong.myexcel.core;

import java.util.Iterator;
import java.util.Map;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddress;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class XSSFSheetMergeXMLHandler
extends DefaultHandler {
    private final Map<CellAddress, CellAddress> mergeCellMapping;

    public XSSFSheetMergeXMLHandler(Map<CellAddress, CellAddress> mergeCellMapping) {
        this.mergeCellMapping = mergeCellMapping;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (uri != null && !uri.equals("http://schemas.openxmlformats.org/spreadsheetml/2006/main")) {
            return;
        }
        if ("mergeCell".equals(localName) || "x:mergeCell".equals(localName)) {
            String range = attributes.getValue("ref");
            Iterator iterator = CellRangeAddress.valueOf((String)range).iterator();
            CellAddress firstCellAddress = null;
            while (iterator.hasNext()) {
                CellAddress cellAddress = (CellAddress)iterator.next();
                if (firstCellAddress == null) {
                    firstCellAddress = cellAddress;
                    continue;
                }
                this.mergeCellMapping.put(cellAddress, firstCellAddress);
            }
        }
    }
}

