/*
 * Decompiled with CFR 0.152.
 */
package com.github.lkqm.hcnet.handler;

import com.github.lkqm.hcnet.HCNetSDK;
import com.github.lkqm.hcnet.handler.AbstractHandler;
import com.github.lkqm.hcnet.model.FaceSnapEvent;
import com.github.lkqm.hcnet.model.FaceSnapInfo;
import com.github.lkqm.hcnet.util.InnerUtils;
import com.github.lkqm.hcnet.util.JnaUtils;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;

public abstract class AbstractFaceSnapHandler
extends AbstractHandler {
    public abstract void handle(FaceSnapEvent var1);

    @Override
    public boolean accept(long command) {
        return command == 4370L;
    }

    @Override
    public void invoke(NativeLong lCommand, HCNetSDK.NET_DVR_ALARMER pAlarmer, HCNetSDK.RECV_ALARM pAlarmInfo, int dwBufLen, Pointer pUser) {
        if (this.accept(lCommand.longValue())) {
            FaceSnapEvent event = new FaceSnapEvent();
            event.setDeviceInfo(this.resolveDeviceInfo(pAlarmer));
            event.setFaceSnapInfo(this.resolveFaceSnapInfo(pAlarmInfo));
            this.handle(event);
        }
    }

    private FaceSnapInfo resolveFaceSnapInfo(HCNetSDK.RECV_ALARM pAlarmInfo) {
        HCNetSDK.NET_VCA_FACESNAP_RESULT strFaceSnapInfo = new HCNetSDK.NET_VCA_FACESNAP_RESULT();
        JnaUtils.pointerToStructure(pAlarmInfo.getPointer(), strFaceSnapInfo);
        HCNetSDK.NET_VCA_RECT strRect = strFaceSnapInfo.struRect;
        HCNetSDK.NET_VCA_HUMAN_FEATURE strFaceFeature = strFaceSnapInfo.struFeature;
        FaceSnapInfo faceInfo = new FaceSnapInfo();
        faceInfo.setFaceScore(strFaceSnapInfo.dwFaceScore);
        if (strFaceSnapInfo.dwFacePicLen > 0) {
            byte[] faceBytes = JnaUtils.pointerToBytes(strFaceSnapInfo.pBuffer1, strFaceSnapInfo.dwFacePicLen);
            faceInfo.setFaceImageBytes(faceBytes);
        }
        if (strFaceSnapInfo.dwBackgroundPicLen > 0) {
            byte[] backgroundBytes = JnaUtils.pointerToBytes(strFaceSnapInfo.pBuffer2, strFaceSnapInfo.dwBackgroundPicLen);
            faceInfo.setBackgroundImageBytes(backgroundBytes);
        }
        int absTime = strFaceSnapInfo.dwAbsTime;
        faceInfo.setSnapTimestamp(InnerUtils.hikAbsTimeToTimestamp(absTime));
        faceInfo.setFacePicId(strFaceSnapInfo.dwFacePicID);
        faceInfo.setStayDurationMs((long)(strFaceSnapInfo.fStayDuration * 1000.0f));
        faceInfo.setRepeatTimes(strFaceSnapInfo.byRepeatTimes);
        FaceSnapInfo.FaceRect faceRect = new FaceSnapInfo.FaceRect(strRect.fX, strRect.fY, strRect.fWidth, strRect.fHeight);
        faceInfo.setFaceRect(faceRect);
        FaceSnapInfo.FaceFuture faceFuture = new FaceSnapInfo.FaceFuture();
        faceInfo.setFaceFuture(faceFuture);
        faceFuture.setAge(strFaceFeature.byAge);
        faceFuture.setEyeGlass(strFaceFeature.byEyeGlass);
        faceFuture.setAgeGroup(strFaceFeature.byAgeGroup);
        faceFuture.setAgeDeviation(strFaceFeature.byAgeDeviation);
        return faceInfo;
    }
}

