/*
 * Decompiled with CFR 0.152.
 */
package com.github.lkqm.hcnet.handler;

import com.github.lkqm.hcnet.HCNetSDK;
import com.github.lkqm.hcnet.handler.AbstractHandler;
import com.github.lkqm.hcnet.model.FreshCardEvent;
import com.github.lkqm.hcnet.model.IDCardInfo;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import java.util.Calendar;
import java.util.Date;

public abstract class AbstractFreshCardHandler
extends AbstractHandler {
    public abstract void handle(FreshCardEvent var1);

    @Override
    public boolean accept(long command) {
        return command == 20992L;
    }

    @Override
    public void invoke(NativeLong lCommand, HCNetSDK.NET_DVR_ALARMER pAlarmer, HCNetSDK.RECV_ALARM pAlarmInfo, int dwBufLen, Pointer pUser) {
        if (this.accept(lCommand.longValue())) {
            FreshCardEvent event = new FreshCardEvent();
            event.setCardInfo(this.resolveIdCardInfo(pAlarmInfo));
            event.setDeviceInfo(this.resolveDeviceInfo(pAlarmer));
            this.handle(event);
        }
    }

    private IDCardInfo resolveIdCardInfo(HCNetSDK.RECV_ALARM pAlarmInfo) {
        IDCardInfo cardInfo = new IDCardInfo();
        HCNetSDK.NET_DVR_ID_CARD_INFO_ALARM idCardInfoAlarm = new HCNetSDK.NET_DVR_ID_CARD_INFO_ALARM();
        idCardInfoAlarm.write();
        Pointer pCardInfo = idCardInfoAlarm.getPointer();
        pCardInfo.write(0L, pAlarmInfo.getPointer().getByteArray(0L, idCardInfoAlarm.size()), 0, idCardInfoAlarm.size());
        idCardInfoAlarm.read();
        HCNetSDK.NET_DVR_ID_CARD_INFO idCardCfg = idCardInfoAlarm.struIDCardCfg;
        cardInfo.setIdNumber(new String(idCardCfg.byIDNum).trim());
        cardInfo.setName(new String(idCardCfg.byName).trim());
        cardInfo.setAddress(new String(idCardCfg.byAddr).trim());
        cardInfo.setSex(idCardCfg.bySex);
        cardInfo.setNation(idCardCfg.byNation);
        cardInfo.setIssuingAuthority(new String(idCardCfg.byIssuingAuthority).trim());
        cardInfo.setTermValidity(idCardCfg.byTermOfValidity);
        cardInfo.setBirth(this.convertToDate(idCardCfg.struBirth));
        cardInfo.setValidityStartTime(this.convertToDate(idCardCfg.struStartDate));
        if (idCardCfg.byTermOfValidity == 0) {
            cardInfo.setValidityEndTime(this.convertToDate(idCardCfg.struEndDate));
        }
        return cardInfo;
    }

    private Date convertToDate(HCNetSDK.NET_DVR_DATE dvrDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(dvrDate.wYear, dvrDate.byMonth - 1, dvrDate.byDay);
        return calendar.getTime();
    }
}

