/*
 * Decompiled with CFR 0.152.
 */
package com.github.lkqm.hcnet.handler;

import com.github.lkqm.hcnet.HCNetSDK;
import com.github.lkqm.hcnet.util.InnerUtils;
import com.sun.jna.NativeLong;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.ByteByReference;
import java.io.File;
import java.util.Date;

public class VideoFileStoreCallback
implements HCNetSDK.FRealDataCallBack_V30 {
    private final String baseDir;
    private byte[] header;

    public VideoFileStoreCallback(String baseDir) {
        this.baseDir = baseDir;
    }

    @Override
    public void invoke(NativeLong lRealHandle, int dwDataType, ByteByReference pBuffer, int dwBufSize, Pointer pUser) {
        byte[] bytes = pBuffer.getPointer().getByteArray(0L, dwBufSize);
        if (dwDataType == 1) {
            this.header = bytes;
        } else if (dwDataType == 2 && dwBufSize > 0) {
            String videoPath = this.getVideoFilePath();
            File videoFile = new File(videoPath);
            if (!videoFile.exists()) {
                InnerUtils.writeFile(this.header, videoPath);
            }
            InnerUtils.writeFile(bytes, videoPath);
        }
    }

    protected String getVideoFilePath() {
        String filename = InnerUtils.formatDate(new Date(), "yyyyMMdd") + ".mp4";
        return this.baseDir + File.separator + filename;
    }
}

