/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.ssm.test.dao;

import com.google.code.ssm.api.InvalidateSingleCache;
import com.google.code.ssm.api.ParameterDataUpdateContent;
import com.google.code.ssm.api.ParameterValueKeyProvider;
import com.google.code.ssm.api.ReadThroughMultiCache;
import com.google.code.ssm.api.ReadThroughMultiCacheOption;
import com.google.code.ssm.api.ReadThroughSingleCache;
import com.google.code.ssm.api.ReturnDataUpdateContent;
import com.google.code.ssm.api.UpdateSingleCache;
import com.google.code.ssm.test.dao.AppUserDAO;
import com.google.code.ssm.test.entity.AppUser;
import com.google.code.ssm.test.entity.AppUserPK;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.stereotype.Service;

@Service
public class AppUserDAOImpl
implements AppUserDAO {
    private static final String PREFIX = "1/";
    private static final String SINGLE_NS = "1/user/s";
    private static final String LIST_NS = "1/user/l";
    private static final Map<AppUserPK, AppUser> map = new ConcurrentHashMap<AppUserPK, AppUser>();
    private static final Map<Integer, List<AppUser>> userIdApp = new ConcurrentHashMap<Integer, List<AppUser>>();

    @Override
    @UpdateSingleCache(namespace="1/user/s", expiration=2)
    public AppUserPK create(@ParameterDataUpdateContent @ParameterValueKeyProvider AppUser entity) {
        map.put(entity.getPK(), entity);
        List<AppUser> list = userIdApp.get(entity.getUserId());
        if (list == null) {
            list = new ArrayList<AppUser>();
            userIdApp.put(entity.getUserId(), list);
        }
        list.add(entity);
        return entity.getPK();
    }

    @Override
    @ReadThroughSingleCache(namespace="1/user/s", expiration=0)
    public AppUser getByPk(@ParameterValueKeyProvider AppUserPK pk) {
        return this.getByPKFromDB(pk);
    }

    @Override
    @UpdateSingleCache(namespace="1/user/s", expiration=2)
    @ReturnDataUpdateContent
    public AppUser update(@ParameterValueKeyProvider AppUser entity) {
        AppUser appUser = entity;
        map.put(entity.getPK(), entity);
        List<AppUser> list = userIdApp.get(entity.getUserId());
        if (list == null) {
            list = new ArrayList<AppUser>();
            userIdApp.put(entity.getUserId(), list);
        }
        list.add(entity);
        assert (appUser.getApplicationId() == entity.getApplicationId());
        assert (appUser.getUserId() == entity.getUserId());
        return appUser;
    }

    @Override
    @InvalidateSingleCache(namespace="1/user/s")
    public void remove(@ParameterValueKeyProvider AppUserPK pk) {
        AppUser appUser = map.remove(pk);
        List<AppUser> list = userIdApp.get(pk.getUserId());
        if (list != null) {
            list.remove(appUser);
        }
    }

    @Override
    @ReadThroughMultiCache(namespace="1/user/s", expiration=0, option=@ReadThroughMultiCacheOption(generateKeysFromResult=true))
    public List<AppUser> getList(@ParameterValueKeyProvider(order=0) int userId, @ParameterValueKeyProvider(order=1) List<Integer> appsIds) {
        ArrayList<AppUser> list = new ArrayList<AppUser>();
        for (Integer appId : appsIds) {
            AppUser au = map.get(new AppUserPK(userId, appId));
            if (au == null) continue;
            list.add(au);
        }
        return list;
    }

    @Override
    @ReadThroughSingleCache(namespace="1/user/l", expiration=0)
    public List<Integer> getAppIdList(@ParameterValueKeyProvider(order=0) int userId, @ParameterValueKeyProvider(order=1) boolean authorized) {
        List<AppUser> list = userIdApp.get(userId);
        ArrayList<Integer> result = new ArrayList<Integer>();
        if (list != null) {
            for (AppUser appUser : list) {
                if (appUser.isEnabled() != authorized) continue;
                result.add(appUser.getApplicationId());
            }
        }
        return result;
    }

    @Override
    @ReadThroughMultiCache(namespace="1/user/s", expiration=0, option=@ReadThroughMultiCacheOption(generateKeysFromResult=true))
    public List<AppUser> getUsersList(@ParameterValueKeyProvider(order=1) int applicationId, @ParameterValueKeyProvider(order=0) List<Integer> userIds) {
        ArrayList<AppUser> list = new ArrayList<AppUser>();
        for (Integer userId : userIds) {
            AppUser au = map.get(new AppUserPK(userId, applicationId));
            if (au == null || !au.isEnabled()) continue;
            list.add(au);
        }
        return list;
    }

    @Override
    @ReadThroughMultiCache(namespace="1/user/s", expiration=0, option=@ReadThroughMultiCacheOption(generateKeysFromResult=true))
    public List<AppUser> getUsersListFromCache(@ParameterValueKeyProvider(order=1) int applicationId, @ParameterValueKeyProvider(order=0) List<Integer> usersIds, Collection<Integer> notFoundUsersIds) {
        notFoundUsersIds.addAll(usersIds);
        return null;
    }

    @Override
    @UpdateSingleCache(namespace="1/user/l", expiration=2)
    public void updateListInCache(@ParameterValueKeyProvider(order=0) int userId, @ParameterValueKeyProvider(order=1) boolean authorized, @ParameterDataUpdateContent List<Integer> appsIdsList) {
    }

    @Override
    @UpdateSingleCache(namespace="1/user/s", expiration=0)
    @ReturnDataUpdateContent
    public AppUser getByPKFromDB(@ParameterValueKeyProvider AppUserPK pk) {
        AppUser appUser = map.get(pk);
        assert (appUser == null || appUser.getApplicationId() == pk.getApplicationId());
        assert (appUser == null || appUser.getUserId() == pk.getUserId());
        return appUser;
    }
}

