/*
 * Decompiled with CFR 0.152.
 */
package com.ibatis.common.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class Stopwatch {
    private Map taskMap = new HashMap();
    private String currentTaskName = null;
    private long currentTaskTime = 0L;

    public Iterator getTaskNames() {
        return this.taskMap.keySet().iterator();
    }

    public long getTaskCount(String string) {
        return ((TaskStat)this.taskMap.get(string)).getCount();
    }

    public long getTotalTaskTime(String string) {
        return ((TaskStat)this.taskMap.get(string)).getTotal();
    }

    public long getMaxTaskTime(String string) {
        return ((TaskStat)this.taskMap.get(string)).getMax();
    }

    public long getMinTaskTime(String string) {
        return ((TaskStat)this.taskMap.get(string)).getMin();
    }

    public long getAvgTaskTime(String string) {
        return ((TaskStat)this.taskMap.get(string)).getAverage();
    }

    public void start(String string) {
        this.currentTaskName = string;
        this.currentTaskTime = System.currentTimeMillis();
    }

    public void stop() {
        this.currentTaskTime = System.currentTimeMillis() - this.currentTaskTime;
        this.appendTaskTime(this.currentTaskName, this.currentTaskTime);
    }

    private synchronized void appendTaskTime(String string, long l) {
        TaskStat taskStat = (TaskStat)this.taskMap.get(string);
        if (taskStat == null) {
            taskStat = new TaskStat();
            this.taskMap.put(string, taskStat);
        }
        taskStat.appendTaskTime(l);
    }

    public void mergeStopwatch(Stopwatch stopwatch) {
        Iterator iterator = stopwatch.getTaskNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            long l = stopwatch.getTotalTaskTime(string);
            this.appendTaskTime(string, l);
        }
    }

    public synchronized void reset() {
        this.taskMap.clear();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Task,Count,Total,Max,Min,Avg\n");
        Iterator iterator = this.getTaskNames();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            long l = this.getTaskCount(string);
            long l2 = this.getTotalTaskTime(string);
            long l3 = this.getMinTaskTime(string);
            long l4 = this.getMaxTaskTime(string);
            long l5 = this.getAvgTaskTime(string);
            stringBuffer.append(string + "," + l + "," + l2 + "," + l4 + "," + l3 + "," + l5 + "\n");
        }
        return stringBuffer.toString();
    }

    private class TaskStat {
        private static final long UNSET = -999999L;
        private long count = 0L;
        private long total = 0L;
        private long min = -999999L;
        private long max = -999999L;

        private TaskStat() {
        }

        public void appendTaskTime(long l) {
            ++this.count;
            this.total += l;
            if (this.max == -999999L || l > this.max) {
                this.max = l;
            }
            if (this.min == -999999L || l < this.min) {
                this.min = l;
            }
        }

        public long getTotal() {
            return this.total;
        }

        public long getMax() {
            return this.max;
        }

        public long getMin() {
            return this.min;
        }

        public long getCount() {
            return this.count;
        }

        public long getAverage() {
            if (this.count > 0L) {
                return Math.round((double)this.total / (double)this.count);
            }
            return 0L;
        }
    }
}

