/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.master;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.data.CommStatus;
import com.intelligt.modbus.jlibmodbus.exception.ModbusIOException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusProtocolException;
import com.intelligt.modbus.jlibmodbus.msg.ModbusRequestBuilder;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusFileRecord;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusMessage;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusRequest;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.msg.base.mei.MEIReadDeviceIdentification;
import com.intelligt.modbus.jlibmodbus.msg.base.mei.ReadDeviceIdentificationCode;
import com.intelligt.modbus.jlibmodbus.msg.response.BroadcastResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.EncapsulatedInterfaceTransportResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadCoilsResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadDiscreteInputsResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadFifoQueueResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadFileRecordResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadHoldingRegistersResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadInputRegistersResponse;
import com.intelligt.modbus.jlibmodbus.msg.response.ReadWriteMultipleRegistersResponse;
import com.intelligt.modbus.jlibmodbus.net.ModbusConnection;
import com.intelligt.modbus.jlibmodbus.net.transport.ModbusTransport;
import com.intelligt.modbus.jlibmodbus.utils.FrameEvent;
import com.intelligt.modbus.jlibmodbus.utils.FrameEventListener;
import com.intelligt.modbus.jlibmodbus.utils.FrameEventListenerList;
import com.intelligt.modbus.jlibmodbus.utils.ModbusExceptionCode;

public abstract class ModbusMaster
implements FrameEventListenerList {
    private final ModbusConnection conn;
    private final BroadcastResponse broadcastResponse = new BroadcastResponse();
    private int transactionId = 0;
    private long requestTime = 0L;

    public ModbusMaster(ModbusConnection conn) {
        this.conn = conn;
    }

    public int getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(int transactionId) {
        this.transactionId = Math.min(Math.abs(transactionId), 65535);
    }

    protected ModbusConnection getConnection() {
        return this.conn;
    }

    protected void connectImpl() throws ModbusIOException {
        this.getConnection().open();
    }

    protected void disconnectImpl() throws ModbusIOException {
        this.getConnection().close();
    }

    public final void connect() throws ModbusIOException {
        if (!this.isConnected()) {
            this.connectImpl();
        }
    }

    public final void disconnect() throws ModbusIOException {
        if (this.isConnected()) {
            this.disconnectImpl();
        }
    }

    public boolean isConnected() {
        return this.getConnection().isOpened();
    }

    protected void sendRequest(ModbusMessage msg) throws ModbusIOException {
        ModbusTransport transport = this.getConnection().getTransport();
        if (transport == null) {
            throw new ModbusIOException("transport is null");
        }
        transport.send(msg);
        this.requestTime = System.currentTimeMillis();
    }

    protected ModbusMessage readResponse(ModbusRequest request) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        return this.getConnection().getTransport().readResponse(request);
    }

    public synchronized ModbusResponse processRequest(ModbusRequest request) throws ModbusProtocolException, ModbusIOException {
        this.sendRequest(request);
        if (request.getServerAddress() != 0) {
            do {
                try {
                    ModbusResponse msg = (ModbusResponse)this.readResponse(request);
                    request.validateResponse(msg);
                    if (msg.getModbusExceptionCode() != ModbusExceptionCode.ACKNOWLEDGE) {
                        if (msg.isException()) {
                            throw new ModbusProtocolException(msg.getModbusExceptionCode());
                        }
                        return msg;
                    }
                }
                catch (ModbusNumberException mne) {
                    Modbus.log().warning(mne.getLocalizedMessage());
                }
            } while (System.currentTimeMillis() - this.requestTime < (long)this.getConnection().getReadTimeout());
            throw new ModbusIOException("Response timeout.");
        }
        this.broadcastResponse.setFunction(request.getFunction());
        return this.broadcastResponse;
    }

    public void setResponseTimeout(int timeout) {
        try {
            this.getConnection().setReadTimeout(timeout);
        }
        catch (Exception e) {
            Modbus.log().warning(e.getLocalizedMessage());
        }
    }

    public final int[] readHoldingRegisters(int serverAddress, int startAddress, int quantity) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = ModbusRequestBuilder.getInstance().buildReadHoldingRegisters(serverAddress, startAddress, quantity);
        ReadHoldingRegistersResponse response = (ReadHoldingRegistersResponse)this.processRequest(request);
        return response.getRegisters();
    }

    public final int[] readInputRegisters(int serverAddress, int startAddress, int quantity) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = ModbusRequestBuilder.getInstance().buildReadInputRegisters(serverAddress, startAddress, quantity);
        ReadInputRegistersResponse response = (ReadInputRegistersResponse)this.processRequest(request);
        return response.getRegisters();
    }

    public final synchronized boolean[] readCoils(int serverAddress, int startAddress, int quantity) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = ModbusRequestBuilder.getInstance().buildReadCoils(serverAddress, startAddress, quantity);
        ReadCoilsResponse response = (ReadCoilsResponse)this.processRequest(request);
        return response.getCoils();
    }

    public final boolean[] readDiscreteInputs(int serverAddress, int startAddress, int quantity) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = ModbusRequestBuilder.getInstance().buildReadDiscreteInputs(serverAddress, startAddress, quantity);
        ReadDiscreteInputsResponse response = (ReadDiscreteInputsResponse)this.processRequest(request);
        return response.getCoils();
    }

    public final void writeSingleCoil(int serverAddress, int startAddress, boolean flag) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        this.processRequest(ModbusRequestBuilder.getInstance().buildWriteSingleCoil(serverAddress, startAddress, flag));
    }

    public final void writeSingleRegister(int serverAddress, int startAddress, int register) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        this.processRequest(ModbusRequestBuilder.getInstance().buildWriteSingleRegister(serverAddress, startAddress, register));
    }

    public final void writeMultipleCoils(int serverAddress, int startAddress, boolean[] coils) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        this.processRequest(ModbusRequestBuilder.getInstance().buildWriteMultipleCoils(serverAddress, startAddress, coils));
    }

    public final void writeMultipleRegisters(int serverAddress, int startAddress, int[] registers) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        this.processRequest(ModbusRequestBuilder.getInstance().buildWriteMultipleRegisters(serverAddress, startAddress, registers));
    }

    public final int[] readWriteMultipleRegisters(int serverAddress, int readAddress, int readQuantity, int writeAddress, int[] registers) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = ModbusRequestBuilder.getInstance().buildReadWriteMultipleRegisters(serverAddress, readAddress, readQuantity, writeAddress, registers);
        ReadWriteMultipleRegistersResponse response = (ReadWriteMultipleRegistersResponse)this.processRequest(request);
        return response.getRegisters();
    }

    public final int[] readFifoQueue(int serverAddress, int fifoPointerAddress) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = ModbusRequestBuilder.getInstance().buildReadFifoQueue(serverAddress, fifoPointerAddress);
        ReadFifoQueueResponse response = (ReadFifoQueueResponse)this.processRequest(request);
        return response.getFifoValueRegister();
    }

    public final ModbusFileRecord[] readFileRecord(int serverAddress, ModbusFileRecord[] records) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        ModbusRequest request = ModbusRequestBuilder.getInstance().buildReadFileRecord(serverAddress, records);
        ReadFileRecordResponse response = (ReadFileRecordResponse)this.processRequest(request);
        return response.getFileRecords();
    }

    public final void writeFileRecord(int serverAddress, ModbusFileRecord record) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        this.processRequest(ModbusRequestBuilder.getInstance().buildWriteFileRecord(serverAddress, record));
    }

    public final void maskWriteRegister(int serverAddress, int startAddress, int and, int or) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        this.processRequest(ModbusRequestBuilder.getInstance().buildMaskWriteRegister(serverAddress, startAddress, and, or));
    }

    public abstract int readExceptionStatus(int var1) throws ModbusProtocolException, ModbusNumberException, ModbusIOException;

    public abstract byte[] reportSlaveId(int var1) throws ModbusProtocolException, ModbusNumberException, ModbusIOException;

    public abstract CommStatus getCommEventCounter(int var1) throws ModbusProtocolException, ModbusNumberException, ModbusIOException;

    public abstract CommStatus getCommEventLog(int var1) throws ModbusProtocolException, ModbusNumberException, ModbusIOException;

    public abstract void diagnosticsReturnQueryData(int var1, int var2) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract void diagnosticsRestartCommunicationsOption(int var1, boolean var2) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract int diagnosticsReturnDiagnosticRegister(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract void diagnosticsChangeAsciiInputDelimiter(int var1, int var2) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract void diagnosticsForceListenOnlyMode(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract void diagnosticsClearCountersAndDiagnosticRegister(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract int diagnosticsReturnBusMessageCount(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract int diagnosticsReturnBusCommunicationErrorCount(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract int diagnosticsReturnBusExceptionErrorCount(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract int diagnosticsReturnSlaveMessageCount(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract int diagnosticsReturnSlaveNoResponseCount(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract int diagnosticsReturnSlaveNAKCount(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract int diagnosticsReturnSlaveBusyCount(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract int diagnosticsReturnBusCharacterOverrunCount(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public abstract void diagnosticsClearOverrunCounterAndFlag(int var1) throws ModbusNumberException, ModbusProtocolException, ModbusIOException;

    public final MEIReadDeviceIdentification readDeviceIdentification(int serverAddress, int objectId, ReadDeviceIdentificationCode readDeviceId) throws ModbusProtocolException, ModbusNumberException, ModbusIOException {
        EncapsulatedInterfaceTransportResponse response = (EncapsulatedInterfaceTransportResponse)this.processRequest(ModbusRequestBuilder.getInstance().buildReadDeviceIdentification(serverAddress, objectId, readDeviceId));
        return (MEIReadDeviceIdentification)response.getMei();
    }

    @Override
    public void addListener(FrameEventListener listener) {
        this.getConnection().addListener(listener);
    }

    @Override
    public void removeListener(FrameEventListener listener) {
        this.getConnection().removeListener(listener);
    }

    @Override
    public void removeListeners() {
        this.getConnection().removeListeners();
    }

    @Override
    public void fireFrameReceivedEvent(FrameEvent event) {
        this.getConnection().fireFrameReceivedEvent(event);
    }

    @Override
    public void fireFrameSentEvent(FrameEvent event) {
        this.getConnection().fireFrameSentEvent(event);
    }

    @Override
    public int countListeners() {
        return this.getConnection().countListeners();
    }
}

