/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.msg.request;

import com.intelligt.modbus.jlibmodbus.Modbus;
import com.intelligt.modbus.jlibmodbus.data.DataHolder;
import com.intelligt.modbus.jlibmodbus.exception.ModbusNumberException;
import com.intelligt.modbus.jlibmodbus.exception.ModbusProtocolException;
import com.intelligt.modbus.jlibmodbus.msg.base.ModbusResponse;
import com.intelligt.modbus.jlibmodbus.msg.request.WriteSingleRegisterRequest;
import com.intelligt.modbus.jlibmodbus.msg.response.WriteSingleCoilResponse;
import com.intelligt.modbus.jlibmodbus.utils.ModbusFunctionCode;

public final class WriteSingleCoilRequest
extends WriteSingleRegisterRequest {
    @Override
    protected Class getResponseClass() {
        return WriteSingleCoilResponse.class;
    }

    @Override
    public ModbusResponse process(DataHolder dataHolder) throws ModbusNumberException {
        WriteSingleCoilResponse response = (WriteSingleCoilResponse)this.getResponse();
        response.setStartAddress(this.getStartAddress());
        response.setValue(this.getValue());
        try {
            dataHolder.writeCoil(this.getStartAddress(), this.getCoil());
        }
        catch (ModbusProtocolException e) {
            response.setException();
            response.setModbusExceptionCode(e.getException().getValue());
        }
        return response;
    }

    @Override
    public boolean validateResponseImpl(ModbusResponse response) {
        if (!(response instanceof WriteSingleCoilResponse)) {
            return false;
        }
        WriteSingleCoilResponse r = (WriteSingleCoilResponse)response;
        return r.getStartAddress() == this.getStartAddress() && r.getValue() == this.getValue();
    }

    public boolean getCoil() {
        return Modbus.toCoil(this.getValue());
    }

    public void setCoil(boolean coil) throws ModbusNumberException {
        this.setValue(Modbus.fromCoil(coil));
    }

    @Override
    public int getFunction() {
        return ModbusFunctionCode.WRITE_SINGLE_COIL.toInt();
    }
}

