/*
 * Decompiled with CFR 0.152.
 */
package com.intelligt.modbus.jlibmodbus.serial;

import com.intelligt.modbus.jlibmodbus.serial.SerialParameters;
import com.intelligt.modbus.jlibmodbus.serial.SerialPort;
import com.intelligt.modbus.jlibmodbus.serial.SerialPortException;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public class SerialPortLoopback
extends SerialPort {
    private static final LinkedBlockingDeque<Byte> tx_from_master_fifo = new LinkedBlockingDeque(8192);
    private static final LinkedBlockingDeque<Byte> rx_to_master_fifo = new LinkedBlockingDeque(8192);
    private final LinkedBlockingDeque<Byte> myWriteFifo;
    private final LinkedBlockingDeque<Byte> myReadFifo;
    private boolean isOpen = false;

    public SerialPortLoopback(SerialParameters sp, boolean isMaster) throws SerialPortException {
        super(sp);
        if (isMaster) {
            this.myWriteFifo = tx_from_master_fifo;
            this.myReadFifo = rx_to_master_fifo;
        } else {
            this.myWriteFifo = rx_to_master_fifo;
            this.myReadFifo = tx_from_master_fifo;
        }
    }

    @Override
    public void write(int b) throws IOException {
        if (!this.myWriteFifo.offer((byte)b)) {
            throw new IOException("Loopback fifo full");
        }
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        if (!this.isOpen) {
            throw new IOException("Loopback is not open");
        }
        byte[] byArray = bytes;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            Byte b = byArray[i];
            if (this.myWriteFifo.offer(b)) continue;
            throw new IOException("Loopback fifo is full");
        }
    }

    @Override
    public void open() throws SerialPortException {
        this.isOpen = true;
    }

    @Override
    public int read() throws IOException {
        if (!this.isOpen) {
            throw new IOException("Loopback is not open");
        }
        try {
            Byte b = this.myReadFifo.poll(this.getReadTimeout(), TimeUnit.MILLISECONDS);
            if (b == null) {
                throw new IOException("Timeout");
            }
            return b & 0xFF;
        }
        catch (InterruptedException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int count = 0;
        for (int i = 0; i < len; ++i) {
            try {
                Byte y = this.myReadFifo.poll(this.getReadTimeout(), TimeUnit.MILLISECONDS);
                if (y == null) break;
                b[i + off] = y;
                ++count;
                continue;
            }
            catch (InterruptedException ex) {
                throw new IOException(ex);
            }
        }
        if (count == 0) {
            throw new IOException("Timeout");
        }
        return count;
    }

    @Override
    public void close() {
        this.isOpen = false;
    }

    @Override
    public boolean isOpened() {
        return this.isOpen;
    }
}

