/*
 * Decompiled with CFR 0.152.
 */
package com.liucf.dbrecord;

import com.liucf.dbrecord.DbRecordException;
import com.liucf.dbrecord.SqlReporter;
import com.liucf.dbrecord.dialect.Dialect;
import com.liucf.dbrecord.dialect.MysqlDialect;
import com.liucf.dbrecord.kit.StrKit;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;

public class Config {
    String name;
    private final ThreadLocal<Connection> threadLocal = new ThreadLocal();
    DataSource dataSource;
    int transactionLevel = 2;
    boolean showSql = false;
    Dialect dialect = new MysqlDialect();

    public Map<String, Object> getAttrsMap() {
        return new HashMap<String, Object>();
    }

    public Map<String, Object> getColumnsMap() {
        return new HashMap<String, Object>();
    }

    public Set<String> getModifyFlagSet() {
        return new HashSet<String>();
    }

    Config() {
    }

    public Config(String name, DataSource dataSource) {
        if (StrKit.isBlank(name)) {
            throw new IllegalArgumentException("Config name can not be blank");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource can not be null");
        }
        this.name = name.trim();
        this.dataSource = dataSource;
    }

    public Config(String name, DataSource dataSource, Dialect dialect) {
        if (StrKit.isBlank(name)) {
            throw new IllegalArgumentException("Config name can not be blank");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource can not be null");
        }
        if (dialect == null) {
            throw new IllegalArgumentException("Dialect can not be null");
        }
        this.name = name.trim();
        this.dataSource = dataSource;
        this.dialect = dialect;
    }

    public Config(String name, DataSource dataSource, Dialect dialect, Boolean showSql, Integer transactionLevel) {
        if (StrKit.isBlank(name)) {
            throw new IllegalArgumentException("Config name can not be blank");
        }
        if (dataSource == null) {
            throw new IllegalArgumentException("DataSource can not be null");
        }
        this.name = name.trim();
        this.dataSource = dataSource;
        if (dialect != null) {
            this.dialect = dialect;
        }
        if (showSql != null) {
            this.showSql = showSql;
        }
        if (transactionLevel != null) {
            this.transactionLevel = transactionLevel;
        }
    }

    public String getName() {
        return this.name;
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    public int getTransactionLevel() {
        return this.transactionLevel;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public final void setThreadLocalConnection(Connection connection) {
        this.threadLocal.set(connection);
    }

    public final void removeThreadLocalConnection() {
        this.threadLocal.remove();
    }

    public final Connection getConnection() throws SQLException {
        Connection conn = this.threadLocal.get();
        if (conn != null) {
            return conn;
        }
        return this.showSql ? new SqlReporter(this.dataSource.getConnection()).getConnection() : this.dataSource.getConnection();
    }

    public final Connection getThreadLocalConnection() {
        return this.threadLocal.get();
    }

    public final void close(ResultSet rs, Statement st, Connection conn) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.threadLocal.get() == null && conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new DbRecordException(e);
            }
        }
    }

    public final void close(Statement st, Connection conn) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.threadLocal.get() == null && conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new DbRecordException(e);
            }
        }
    }

    public final void close(Connection conn) {
        if (this.threadLocal.get() == null && conn != null) {
            try {
                conn.close();
            }
            catch (SQLException e) {
                throw new DbRecordException(e);
            }
        }
    }
}

