/*
 * Decompiled with CFR 0.152.
 */
package com.liucf.dbrecord;

import com.alibaba.druid.pool.DruidDataSource;
import com.liucf.dbrecord.Config;
import com.liucf.dbrecord.DbKit;
import com.liucf.dbrecord.DbPro;
import com.liucf.dbrecord.Page;
import com.liucf.dbrecord.Record;
import com.liucf.dbrecord.TransactionWrap;
import com.liucf.dbrecord.dialect.Dialect;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.List;
import javax.sql.DataSource;

public class Db {
    private static DbPro dbPro = null;

    public static void init(String jdbcURL, String jdbcUser, String jdbcPassword) {
        Db.init("main", "com.mysql.cj.jdbc.Driver", jdbcURL, jdbcUser, jdbcPassword, null, null, false);
    }

    public static void init(String jdbcDriver, String jdbcURL, String jdbcUser, String jdbcPassword) {
        Db.init("main", jdbcDriver, jdbcURL, jdbcUser, jdbcPassword, null, null, false);
    }

    public static void init(String jdbcDriver, String jdbcURL, String jdbcUser, String jdbcPassword, Integer transactionLevel) {
        Db.init("main", jdbcDriver, jdbcURL, jdbcUser, jdbcPassword, transactionLevel, null, false);
    }

    public static void init(String jdbcDriver, String jdbcURL, String jdbcUser, String jdbcPassword, Integer transactionLevel, Dialect dialect) {
        Db.init("main", jdbcDriver, jdbcURL, jdbcUser, jdbcPassword, transactionLevel, dialect, false);
    }

    public static void init(String jdbcDriver, String jdbcURL, String jdbcUser, String jdbcPassword, Integer transactionLevel, Dialect dialect, Boolean showSql) {
        Db.init("main", jdbcDriver, jdbcURL, jdbcUser, jdbcPassword, transactionLevel, dialect, showSql);
    }

    public static void initAlias(String configName, String jdbcURL, String jdbcUser, String jdbcPassword) {
        Db.init(configName, "com.mysql.cj.jdbc.Driver", jdbcURL, jdbcUser, jdbcPassword, null, null, false);
    }

    public static void initAlias(String configName, String jdbcDriver, String jdbcURL, String jdbcUser, String jdbcPassword) {
        Db.init(configName, jdbcDriver, jdbcURL, jdbcUser, jdbcPassword, null, null, false);
    }

    static void init(String configName, String jdbcDriver, String jdbcURL, String jdbcUser, String jdbcPassword, Integer transactionLevel, Dialect dialect, Boolean showSql) {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUrl(jdbcURL);
        dataSource.setUsername(jdbcUser);
        dataSource.setPassword(jdbcPassword);
        dataSource.setDriverClassName(jdbcDriver);
        dataSource.setInitialSize(5);
        dataSource.setMinIdle(5);
        dataSource.setMaxActive(20);
        Db.init(configName, (DataSource)dataSource, transactionLevel, dialect, showSql);
    }

    public static void init(String configName, DataSource dataSource, Integer transactionLevel, Dialect dialect, Boolean showSql) {
        Config config = new Config(configName, dataSource, dialect, showSql, transactionLevel);
        DbKit.addConfig(config);
        dbPro = DbPro.use(configName);
    }

    public static DbPro use() {
        return DbPro.use();
    }

    public static DbPro use(String configName) {
        return DbPro.use(configName);
    }

    public static <T> List<T> query(Config config, Connection conn, String sql, Object ... paras) throws SQLException {
        return dbPro.query(config, conn, sql, paras);
    }

    public static <T> List<T> query(String sql, Object ... paras) {
        return dbPro.query(sql, paras);
    }

    public static <T> List<T> query(String sql) {
        return dbPro.query(sql);
    }

    public static <T> T queryFirst(String sql, Object ... paras) {
        return dbPro.queryFirst(sql, paras);
    }

    public static <T> T queryFirst(String sql) {
        return dbPro.queryFirst(sql);
    }

    public static <T> T queryColumn(String sql, Object ... paras) {
        return dbPro.queryColumn(sql, paras);
    }

    public static <T> T queryColumn(String sql) {
        return dbPro.queryColumn(sql);
    }

    public static String queryStr(String sql, Object ... paras) {
        return dbPro.queryStr(sql, paras);
    }

    public static String queryStr(String sql) {
        return dbPro.queryStr(sql);
    }

    public static Integer queryInt(String sql, Object ... paras) {
        return dbPro.queryInt(sql, paras);
    }

    public static Integer queryInt(String sql) {
        return dbPro.queryInt(sql);
    }

    public static Long queryLong(String sql, Object ... paras) {
        return dbPro.queryLong(sql, paras);
    }

    public static Long queryLong(String sql) {
        return dbPro.queryLong(sql);
    }

    public static Double queryDouble(String sql, Object ... paras) {
        return dbPro.queryDouble(sql, paras);
    }

    public static Double queryDouble(String sql) {
        return dbPro.queryDouble(sql);
    }

    public static Float queryFloat(String sql, Object ... paras) {
        return dbPro.queryFloat(sql, paras);
    }

    public static Float queryFloat(String sql) {
        return dbPro.queryFloat(sql);
    }

    public static BigDecimal queryBigDecimal(String sql, Object ... paras) {
        return dbPro.queryBigDecimal(sql, paras);
    }

    public static BigDecimal queryBigDecimal(String sql) {
        return dbPro.queryBigDecimal(sql);
    }

    public static byte[] queryBytes(String sql, Object ... paras) {
        return dbPro.queryBytes(sql, paras);
    }

    public static byte[] queryBytes(String sql) {
        return dbPro.queryBytes(sql);
    }

    public static Date queryDate(String sql, Object ... paras) {
        return dbPro.queryDate(sql, paras);
    }

    public static Date queryDate(String sql) {
        return dbPro.queryDate(sql);
    }

    public static Time queryTime(String sql, Object ... paras) {
        return dbPro.queryTime(sql, paras);
    }

    public static Time queryTime(String sql) {
        return dbPro.queryTime(sql);
    }

    public static Timestamp queryTimestamp(String sql, Object ... paras) {
        return dbPro.queryTimestamp(sql, paras);
    }

    public static Timestamp queryTimestamp(String sql) {
        return dbPro.queryTimestamp(sql);
    }

    public static Boolean queryBoolean(String sql, Object ... paras) {
        return dbPro.queryBoolean(sql, paras);
    }

    public static Boolean queryBoolean(String sql) {
        return dbPro.queryBoolean(sql);
    }

    public static Number queryNumber(String sql, Object ... paras) {
        return dbPro.queryNumber(sql, paras);
    }

    public static Number queryNumber(String sql) {
        return dbPro.queryNumber(sql);
    }

    static int update(Config config, Connection conn, String sql, Object ... paras) throws SQLException {
        return dbPro.update(config, conn, sql, paras);
    }

    public static int update(String sql, Object ... paras) {
        return dbPro.update(sql, paras);
    }

    public static int update(String sql) {
        return dbPro.update(sql);
    }

    static List<Record> find(Config config, Connection conn, String sql, Object ... paras) throws SQLException {
        return dbPro.find(config, conn, sql, paras);
    }

    public static List<Record> find(String sql, Object ... paras) {
        return dbPro.find(sql, paras);
    }

    public static List<Record> find(String sql) {
        return dbPro.find(sql);
    }

    public static Record findFirst(String sql, Object ... paras) {
        return dbPro.findFirst(sql, paras);
    }

    public static Record findFirst(String sql) {
        return dbPro.findFirst(sql);
    }

    public static Record findById(String tableName, Object idValue) {
        return dbPro.findById(tableName, idValue);
    }

    public static Record findById(String tableName, Number idValue, String columns) {
        return dbPro.findById(tableName, idValue, columns);
    }

    public static Record findById(String tableName, String primaryKey, Number idValue) {
        return dbPro.findById(tableName, primaryKey, idValue);
    }

    public static Record findById(String tableName, String primaryKey, Object idValue, String columns) {
        return dbPro.findById(tableName, primaryKey, idValue, columns);
    }

    public static boolean deleteById(String tableName, Object id) {
        return dbPro.deleteById(tableName, id);
    }

    public static boolean deleteById(String tableName, String primaryKey, Object id) {
        return dbPro.deleteById(tableName, primaryKey, id);
    }

    public static boolean delete(String tableName, String primaryKey, Record record) {
        return dbPro.delete(tableName, primaryKey, record);
    }

    public static boolean delete(String tableName, Record record) {
        return dbPro.delete(tableName, record);
    }

    static Page<Record> paginate(Config config, Connection conn, int pageNumber, int pageSize, String select, boolean count, Object ... paras) throws SQLException {
        return dbPro.paginate(config, conn, pageNumber, pageSize, select, count, paras);
    }

    public static Page<Record> paginate(int pageNumber, int pageSize, String select, boolean count, Object ... paras) {
        return dbPro.paginate(pageNumber, pageSize, select, count, paras);
    }

    public static Page<Record> paginate(int pageNumber, int pageSize, String select) {
        return dbPro.paginate(pageNumber, pageSize, select);
    }

    static boolean save(Config config, Connection conn, String tableName, String primaryKey, Record record) throws SQLException {
        return dbPro.save(config, conn, tableName, primaryKey, record);
    }

    public static boolean save(String tableName, String primaryKey, Record record) {
        return dbPro.save(tableName, primaryKey, record);
    }

    public static boolean save(String tableName, Record record) {
        return dbPro.save(tableName, record);
    }

    static boolean update(Config config, Connection conn, String tableName, String primaryKey, Record record) throws SQLException {
        return dbPro.update(config, conn, tableName, primaryKey, record);
    }

    public static boolean update(String tableName, String primaryKey, Record record) {
        return dbPro.update(tableName, primaryKey, record);
    }

    public static boolean update(String tableName, Record record) {
        return dbPro.update(tableName, record);
    }

    static boolean tx(Config config, int transactionLevel, TransactionWrap atom) {
        return dbPro.tx(config, transactionLevel, atom);
    }

    public static boolean tx(int transactionLevel, TransactionWrap atom) {
        return dbPro.tx(transactionLevel, atom);
    }

    public static boolean tx(TransactionWrap atom) {
        return dbPro.tx(atom);
    }

    public static int[] batch(String sql, Object[][] paras, int batchSize) {
        return dbPro.batch(sql, paras, batchSize);
    }

    public static int[] batch(String sql, String columns, List<?> modelOrRecordList, int batchSize) {
        return dbPro.batch(sql, columns, modelOrRecordList, batchSize);
    }

    public static int[] batch(List<String> sqlList, int batchSize) {
        return dbPro.batch(sqlList, batchSize);
    }
}

