/*
 * Decompiled with CFR 0.152.
 */
package com.liucf.dbrecord;

import com.liucf.dbrecord.Config;
import com.liucf.dbrecord.DbKit;
import com.liucf.dbrecord.DbRecordException;
import com.liucf.dbrecord.NestedTransactionException;
import com.liucf.dbrecord.Page;
import com.liucf.dbrecord.Record;
import com.liucf.dbrecord.RecordBuilder;
import com.liucf.dbrecord.TransactionWrap;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DbPro {
    private final Config config;
    private static final Map<String, DbPro> map = new HashMap<String, DbPro>();

    public DbPro() {
        if (DbKit.config == null) {
            throw new RuntimeException("The main config is null, initialize ActiveRecordPlugin first");
        }
        this.config = DbKit.config;
    }

    public DbPro(String configName) {
        this.config = DbKit.getConfig(configName);
        if (this.config == null) {
            throw new IllegalArgumentException("Config not found by configName: " + configName);
        }
    }

    public static DbPro use(String configName) {
        DbPro result = map.get(configName);
        if (result == null) {
            result = new DbPro(configName);
            map.put(configName, result);
        }
        return result;
    }

    public static DbPro use() {
        return DbPro.use(DbKit.config.name);
    }

    public void setShowSql(boolean showSql) {
        this.config.showSql = showSql;
    }

    <T> List<T> query(Config config, Connection conn, String sql, Object ... paras) throws SQLException {
        ArrayList<Object> result = new ArrayList<Object>();
        PreparedStatement pst = conn.prepareStatement(sql);
        config.dialect.fillStatement(pst, paras);
        ResultSet rs = pst.executeQuery();
        int colAmount = rs.getMetaData().getColumnCount();
        if (colAmount > 1) {
            while (rs.next()) {
                Object[] temp = new Object[colAmount];
                for (int i = 0; i < colAmount; ++i) {
                    temp[i] = rs.getObject(i + 1);
                }
                result.add(temp);
            }
        } else if (colAmount == 1) {
            while (rs.next()) {
                result.add(rs.getObject(1));
            }
        }
        DbKit.closeQuietly(rs, pst);
        return result;
    }

    public <T> List<T> query(String sql, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            List<T> list = this.query(this.config, conn, sql, paras);
            return list;
        }
        catch (Exception e) {
            throw new DbRecordException(e);
        }
        finally {
            this.config.close(conn);
        }
    }

    public <T> List<T> query(String sql) {
        return this.query(sql, DbKit.NULL_PARA_ARRAY);
    }

    public <T> T queryFirst(String sql, Object ... paras) {
        List<T> result = this.query(sql, paras);
        return result.size() > 0 ? (T)result.get(0) : null;
    }

    public <T> T queryFirst(String sql) {
        List<T> result = this.query(sql, DbKit.NULL_PARA_ARRAY);
        return result.size() > 0 ? (T)result.get(0) : null;
    }

    public <T> T queryColumn(String sql, Object ... paras) {
        List<T> result = this.query(sql, paras);
        if (result.size() > 0) {
            T temp = result.get(0);
            if (temp instanceof Object[]) {
                throw new DbRecordException("Only ONE COLUMN can be queried.");
            }
            return temp;
        }
        return null;
    }

    public <T> T queryColumn(String sql) {
        return this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public String queryStr(String sql, Object ... paras) {
        return (String)this.queryColumn(sql, paras);
    }

    public String queryStr(String sql) {
        return (String)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Integer queryInt(String sql, Object ... paras) {
        return (Integer)this.queryColumn(sql, paras);
    }

    public Integer queryInt(String sql) {
        return (Integer)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Long queryLong(String sql, Object ... paras) {
        return (Long)this.queryColumn(sql, paras);
    }

    public Long queryLong(String sql) {
        return (Long)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Double queryDouble(String sql, Object ... paras) {
        return (Double)this.queryColumn(sql, paras);
    }

    public Double queryDouble(String sql) {
        return (Double)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Float queryFloat(String sql, Object ... paras) {
        return (Float)this.queryColumn(sql, paras);
    }

    public Float queryFloat(String sql) {
        return (Float)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public BigDecimal queryBigDecimal(String sql, Object ... paras) {
        return (BigDecimal)this.queryColumn(sql, paras);
    }

    public BigDecimal queryBigDecimal(String sql) {
        return (BigDecimal)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public byte[] queryBytes(String sql, Object ... paras) {
        return (byte[])this.queryColumn(sql, paras);
    }

    public byte[] queryBytes(String sql) {
        return (byte[])this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public java.util.Date queryDate(String sql, Object ... paras) {
        return (java.util.Date)this.queryColumn(sql, paras);
    }

    public java.util.Date queryDate(String sql) {
        return (java.util.Date)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Time queryTime(String sql, Object ... paras) {
        return (Time)this.queryColumn(sql, paras);
    }

    public Time queryTime(String sql) {
        return (Time)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Timestamp queryTimestamp(String sql, Object ... paras) {
        return (Timestamp)this.queryColumn(sql, paras);
    }

    public Timestamp queryTimestamp(String sql) {
        return (Timestamp)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Boolean queryBoolean(String sql, Object ... paras) {
        return (Boolean)this.queryColumn(sql, paras);
    }

    public Boolean queryBoolean(String sql) {
        return (Boolean)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Number queryNumber(String sql, Object ... paras) {
        return (Number)this.queryColumn(sql, paras);
    }

    public Number queryNumber(String sql) {
        return (Number)this.queryColumn(sql, DbKit.NULL_PARA_ARRAY);
    }

    int update(Config config, Connection conn, String sql, Object ... paras) throws SQLException {
        PreparedStatement pst = conn.prepareStatement(sql);
        config.dialect.fillStatement(pst, paras);
        int result = pst.executeUpdate();
        DbKit.closeQuietly(pst);
        return result;
    }

    public int update(String sql, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            int n = this.update(this.config, conn, sql, paras);
            return n;
        }
        catch (Exception e) {
            throw new DbRecordException(e);
        }
        finally {
            this.config.close(conn);
        }
    }

    public int update(String sql) {
        return this.update(sql, DbKit.NULL_PARA_ARRAY);
    }

    private Object getGeneratedKey(PreparedStatement pst) throws SQLException {
        ResultSet rs = pst.getGeneratedKeys();
        Object id = null;
        if (rs.next()) {
            id = rs.getObject(1);
        }
        rs.close();
        return id;
    }

    List<Record> find(Config config, Connection conn, String sql, Object ... paras) throws SQLException {
        PreparedStatement pst = conn.prepareStatement(sql);
        config.dialect.fillStatement(pst, paras);
        ResultSet rs = pst.executeQuery();
        List<Record> result = RecordBuilder.build(config, rs);
        DbKit.closeQuietly(rs, pst);
        return result;
    }

    public List<Record> find(String sql, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            List<Record> list = this.find(this.config, conn, sql, paras);
            return list;
        }
        catch (Exception e) {
            throw new DbRecordException(e);
        }
        finally {
            this.config.close(conn);
        }
    }

    public List<Record> find(String sql) {
        return this.find(sql, DbKit.NULL_PARA_ARRAY);
    }

    public Record findFirst(String sql, Object ... paras) {
        List<Record> result = this.find(sql, paras);
        return result.size() > 0 ? result.get(0) : null;
    }

    public Record findFirst(String sql) {
        List<Record> result = this.find(sql, DbKit.NULL_PARA_ARRAY);
        return result.size() > 0 ? result.get(0) : null;
    }

    public Record findById(String tableName, Object idValue) {
        return this.findById(tableName, this.config.dialect.getDefaultPrimaryKey(), idValue, "*");
    }

    public Record findById(String tableName, Number idValue, String columns) {
        return this.findById(tableName, this.config.dialect.getDefaultPrimaryKey(), idValue, columns);
    }

    public Record findById(String tableName, String primaryKey, Number idValue) {
        return this.findById(tableName, primaryKey, idValue, "*");
    }

    public Record findById(String tableName, String primaryKey, Object idValue, String columns) {
        String sql = this.config.dialect.forDbFindById(tableName, primaryKey, columns);
        List<Record> result = this.find(sql, idValue);
        return result.size() > 0 ? result.get(0) : null;
    }

    public boolean deleteById(String tableName, Object id) {
        return this.deleteById(tableName, this.config.dialect.getDefaultPrimaryKey(), id);
    }

    public boolean deleteById(String tableName, String primaryKey, Object id) {
        if (id == null) {
            throw new IllegalArgumentException("id can not be null");
        }
        String sql = this.config.dialect.forDbDeleteById(tableName, primaryKey);
        return this.update(sql, id) >= 1;
    }

    public boolean delete(String tableName, String primaryKey, Record record) {
        return this.deleteById(tableName, primaryKey, record.get(primaryKey));
    }

    public boolean delete(String tableName, Record record) {
        String defaultPrimaryKey = this.config.dialect.getDefaultPrimaryKey();
        return this.deleteById(tableName, defaultPrimaryKey, record.get(defaultPrimaryKey));
    }

    Page<Record> paginate(Config config, Connection conn, int pageNumber, int pageSize, String querySql, boolean count, Object ... paras) throws SQLException {
        if (pageNumber < 1 || pageSize < 1) {
            throw new DbRecordException("pageNumber and pageSize must be more than 0");
        }
        if (config.dialect.isTakeOverDbPaginate()) {
            return config.dialect.takeOverDbPaginate(conn, pageNumber, pageSize, querySql, count, paras);
        }
        long totalRow = 0L;
        int totalPage = 0;
        if (count) {
            List result = this.query(config, conn, "select count(*) from (" + querySql + ") as _tmp", paras);
            int size = result.size();
            if (size == 1) {
                totalRow = ((Number)result.get(0)).longValue();
            } else if (size > 1) {
                totalRow = result.size();
            } else {
                return new Page<Record>(new ArrayList(0), pageNumber, pageSize, 0, 0);
            }
        }
        totalPage = (int)(totalRow / (long)pageSize);
        if (totalRow % (long)pageSize != 0L) {
            ++totalPage;
        }
        StringBuilder sql = new StringBuilder();
        config.dialect.forPaginate(sql, pageNumber, pageSize, querySql);
        List<Record> list = this.find(config, conn, sql.toString(), paras);
        return new Page<Record>(list, pageNumber, pageSize, totalPage, (int)totalRow);
    }

    public Page<Record> paginate(int pageNumber, int pageSize, String select, boolean count, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            Page<Record> page = this.paginate(this.config, conn, pageNumber, pageSize, select, count, paras);
            return page;
        }
        catch (Exception e) {
            throw new DbRecordException(e);
        }
        finally {
            this.config.close(conn);
        }
    }

    public Page<Record> paginate(int pageNumber, int pageSize, String select, Object ... paras) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            Page<Record> page = this.paginate(this.config, conn, pageNumber, pageSize, select, true, paras);
            return page;
        }
        catch (Exception e) {
            throw new DbRecordException(e);
        }
        finally {
            this.config.close(conn);
        }
    }

    public Page<Record> paginate(int pageNumber, int pageSize, String select) {
        return this.paginate(pageNumber, pageSize, select, DbKit.NULL_PARA_ARRAY);
    }

    boolean save(Config config, Connection conn, String tableName, String primaryKey, Record record) throws SQLException {
        ArrayList<Object> paras = new ArrayList<Object>();
        StringBuilder sql = new StringBuilder();
        config.dialect.forDbSave(sql, paras, tableName, record);
        PreparedStatement pst = config.dialect.isOracle() ? conn.prepareStatement(sql.toString(), new String[]{primaryKey}) : conn.prepareStatement(sql.toString(), 1);
        config.dialect.fillStatement(pst, paras);
        int result = pst.executeUpdate();
        record.set(primaryKey, this.getGeneratedKey(pst));
        DbKit.closeQuietly(pst);
        return result >= 1;
    }

    public boolean save(String tableName, String primaryKey, Record record) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            boolean bl = this.save(this.config, conn, tableName, primaryKey, record);
            return bl;
        }
        catch (Exception e) {
            throw new DbRecordException(e);
        }
        finally {
            this.config.close(conn);
        }
    }

    public boolean save(String tableName, Record record) {
        return this.save(tableName, this.config.dialect.getDefaultPrimaryKey(), record);
    }

    boolean update(Config config, Connection conn, String tableName, String primaryKey, Record record) throws SQLException {
        Object id = record.get(primaryKey);
        if (id == null) {
            throw new DbRecordException("You can't update model without Primary Key.");
        }
        StringBuilder sql = new StringBuilder();
        ArrayList<Object> paras = new ArrayList<Object>();
        config.dialect.forDbUpdate(tableName, primaryKey, id, record, sql, paras);
        if (paras.size() <= 1) {
            return false;
        }
        return this.update(config, conn, sql.toString(), paras.toArray()) >= 1;
    }

    public boolean update(String tableName, String primaryKey, Record record) {
        Connection conn = null;
        try {
            conn = this.config.getConnection();
            boolean bl = this.update(this.config, conn, tableName, primaryKey, record);
            return bl;
        }
        catch (Exception e) {
            throw new DbRecordException(e);
        }
        finally {
            this.config.close(conn);
        }
    }

    public boolean update(String tableName, Record record) {
        return this.update(tableName, this.config.dialect.getDefaultPrimaryKey(), record);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean tx(Config config, int transactionLevel, TransactionWrap atom) {
        Connection conn = config.getThreadLocalConnection();
        if (conn != null) {
            try {
                boolean result;
                if (conn.getTransactionIsolation() < transactionLevel) {
                    conn.setTransactionIsolation(transactionLevel);
                }
                if (!(result = atom.run())) throw new NestedTransactionException("Notice the outer transaction that the nested transaction return false");
                return true;
            }
            catch (SQLException e) {
                throw new DbRecordException(e);
            }
        }
        Boolean autoCommit = null;
        try {
            conn = config.getConnection();
            autoCommit = conn.getAutoCommit();
            config.setThreadLocalConnection(conn);
            conn.setTransactionIsolation(transactionLevel);
            conn.setAutoCommit(false);
            boolean result = atom.run();
            if (result) {
                conn.commit();
            } else {
                conn.rollback();
            }
            boolean bl = result;
            return bl;
        }
        catch (NestedTransactionException e) {
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            boolean e1 = false;
            return e1;
        }
        catch (Throwable t) {
            RuntimeException runtimeException;
            if (conn != null) {
                try {
                    conn.rollback();
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
            if (t instanceof RuntimeException) {
                runtimeException = (RuntimeException)t;
                throw runtimeException;
            }
            runtimeException = new DbRecordException(t);
            throw runtimeException;
        }
        finally {
            try {
                if (conn != null) {
                    if (autoCommit != null) {
                        conn.setAutoCommit(autoCommit);
                    }
                    conn.close();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            finally {
                config.removeThreadLocalConnection();
            }
        }
    }

    public boolean tx(int transactionLevel, TransactionWrap atom) {
        return this.tx(this.config, transactionLevel, atom);
    }

    public boolean tx(TransactionWrap atom) {
        return this.tx(this.config, this.config.getTransactionLevel(), atom);
    }

    private int[] batch(Config config, Connection conn, String sql, Object[][] paras, int batchSize) throws SQLException {
        if (paras == null || paras.length == 0) {
            throw new IllegalArgumentException("The paras array length must more than 0.");
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException("The batchSize must more than 0.");
        }
        int counter = 0;
        int pointer = 0;
        int[] result = new int[paras.length];
        PreparedStatement pst = conn.prepareStatement(sql);
        for (int i = 0; i < paras.length; ++i) {
            for (int j = 0; j < paras[i].length; ++j) {
                Object value = paras[i][j];
                if (config.dialect.isOracle()) {
                    if (value instanceof Date) {
                        pst.setDate(j + 1, (Date)value);
                        continue;
                    }
                    if (value instanceof Timestamp) {
                        pst.setTimestamp(j + 1, (Timestamp)value);
                        continue;
                    }
                    pst.setObject(j + 1, value);
                    continue;
                }
                pst.setObject(j + 1, value);
            }
            pst.addBatch();
            if (++counter < batchSize) continue;
            counter = 0;
            int[] r = pst.executeBatch();
            conn.commit();
            for (int k = 0; k < r.length; ++k) {
                result[pointer++] = r[k];
            }
        }
        int[] r = pst.executeBatch();
        conn.commit();
        for (int k = 0; k < r.length; ++k) {
            result[pointer++] = r[k];
        }
        DbKit.closeQuietly(pst);
        return result;
    }

    public int[] batch(String sql, Object[][] paras, int batchSize) {
        Connection conn = null;
        Boolean autoCommit = null;
        try {
            conn = this.config.getConnection();
            autoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            int[] nArray = this.batch(this.config, conn, sql, paras, batchSize);
            return nArray;
        }
        catch (Exception e) {
            throw new DbRecordException(e);
        }
        finally {
            if (autoCommit != null) {
                try {
                    conn.setAutoCommit(autoCommit);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.config.close(conn);
        }
    }

    private int[] batch(Config config, Connection conn, String sql, String columns, List list, int batchSize) throws SQLException {
        if (list == null || list.size() == 0) {
            return new int[0];
        }
        Object element = list.get(0);
        if (!(element instanceof Record)) {
            throw new IllegalArgumentException("The element in list must be Model or Record.");
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException("The batchSize must more than 0.");
        }
        String[] columnArray = columns.split(",");
        for (int i = 0; i < columnArray.length; ++i) {
            columnArray[i] = columnArray[i].trim();
        }
        int counter = 0;
        int pointer = 0;
        int size = list.size();
        int[] result = new int[size];
        PreparedStatement pst = conn.prepareStatement(sql);
        for (int i = 0; i < size; ++i) {
            Map<String, Object> map = ((Record)list.get(i)).getColumns();
            for (int j = 0; j < columnArray.length; ++j) {
                Object value = map.get(columnArray[j]);
                if (config.dialect.isOracle()) {
                    if (value instanceof Date) {
                        pst.setDate(j + 1, (Date)value);
                        continue;
                    }
                    if (value instanceof Timestamp) {
                        pst.setTimestamp(j + 1, (Timestamp)value);
                        continue;
                    }
                    pst.setObject(j + 1, value);
                    continue;
                }
                pst.setObject(j + 1, value);
            }
            pst.addBatch();
            if (++counter < batchSize) continue;
            counter = 0;
            int[] r = pst.executeBatch();
            conn.commit();
            for (int k = 0; k < r.length; ++k) {
                result[pointer++] = r[k];
            }
        }
        int[] r = pst.executeBatch();
        conn.commit();
        for (int k = 0; k < r.length; ++k) {
            result[pointer++] = r[k];
        }
        DbKit.closeQuietly(pst);
        return result;
    }

    public int[] batch(String sql, String columns, List modelOrRecordList, int batchSize) {
        Connection conn = null;
        Boolean autoCommit = null;
        try {
            conn = this.config.getConnection();
            autoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            int[] nArray = this.batch(this.config, conn, sql, columns, modelOrRecordList, batchSize);
            return nArray;
        }
        catch (Exception e) {
            throw new DbRecordException(e);
        }
        finally {
            if (autoCommit != null) {
                try {
                    conn.setAutoCommit(autoCommit);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.config.close(conn);
        }
    }

    private int[] batch(Config config, Connection conn, List<String> sqlList, int batchSize) throws SQLException {
        if (sqlList == null || sqlList.size() == 0) {
            throw new IllegalArgumentException("The sqlList length must more than 0.");
        }
        if (batchSize < 1) {
            throw new IllegalArgumentException("The batchSize must more than 0.");
        }
        int counter = 0;
        int pointer = 0;
        int size = sqlList.size();
        int[] result = new int[size];
        Statement st = conn.createStatement();
        for (int i = 0; i < size; ++i) {
            st.addBatch(sqlList.get(i));
            if (++counter < batchSize) continue;
            counter = 0;
            int[] r = st.executeBatch();
            conn.commit();
            for (int k = 0; k < r.length; ++k) {
                result[pointer++] = r[k];
            }
        }
        int[] r = st.executeBatch();
        conn.commit();
        for (int k = 0; k < r.length; ++k) {
            result[pointer++] = r[k];
        }
        DbKit.closeQuietly(st);
        return result;
    }

    public int[] batch(List<String> sqlList, int batchSize) {
        Connection conn = null;
        Boolean autoCommit = null;
        try {
            conn = this.config.getConnection();
            autoCommit = conn.getAutoCommit();
            conn.setAutoCommit(false);
            int[] nArray = this.batch(this.config, conn, sqlList, batchSize);
            return nArray;
        }
        catch (Exception e) {
            throw new DbRecordException(e);
        }
        finally {
            if (autoCommit != null) {
                try {
                    conn.setAutoCommit(autoCommit);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.config.close(conn);
        }
    }
}

