/*
 * Decompiled with CFR 0.152.
 */
package com.liucf.dbrecord.dialect;

import com.liucf.dbrecord.Db;
import com.liucf.dbrecord.DbKit;
import com.liucf.dbrecord.DbRecordException;
import com.liucf.dbrecord.Page;
import com.liucf.dbrecord.Record;
import com.liucf.dbrecord.RecordBuilder;
import com.liucf.dbrecord.dialect.Dialect;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AnsiSqlDialect
extends Dialect {
    @Override
    public String forTableBuilderDoBuild(String tableName) {
        return "select * from " + tableName + " where 1 = 2";
    }

    @Override
    public String forDbFindById(String tableName, String primaryKey, String columns) {
        StringBuilder sql = new StringBuilder("select ");
        if (columns.trim().equals("*")) {
            sql.append(columns);
        } else {
            String[] columnsArray = columns.split(",");
            for (int i = 0; i < columnsArray.length; ++i) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append(columnsArray[i].trim());
            }
        }
        sql.append(" from ");
        sql.append(tableName.trim());
        sql.append(" where ").append(primaryKey).append(" = ?");
        return sql.toString();
    }

    @Override
    public String forDbDeleteById(String tableName, String primaryKey) {
        StringBuilder sql = new StringBuilder("delete from ");
        sql.append(tableName.trim());
        sql.append(" where ").append(primaryKey).append(" = ?");
        return sql.toString();
    }

    @Override
    public void forDbSave(StringBuilder sql, List<Object> paras, String tableName, Record record) {
        sql.append("insert into ");
        sql.append(tableName.trim()).append("(");
        StringBuilder temp = new StringBuilder();
        temp.append(") values(");
        for (Map.Entry<String, Object> e : record.getColumns().entrySet()) {
            if (paras.size() > 0) {
                sql.append(", ");
                temp.append(", ");
            }
            sql.append(e.getKey());
            temp.append("?");
            paras.add(e.getValue());
        }
        sql.append(temp.toString()).append(")");
    }

    @Override
    public void forDbUpdate(String tableName, String primaryKey, Object id, Record record, StringBuilder sql, List<Object> paras) {
        sql.append("update ").append(tableName.trim()).append(" set ");
        for (Map.Entry<String, Object> e : record.getColumns().entrySet()) {
            String colName = e.getKey();
            if (primaryKey.equalsIgnoreCase(colName)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
            }
            sql.append(colName).append(" = ? ");
            paras.add(e.getValue());
        }
        sql.append(" where ").append(primaryKey).append(" = ?");
        paras.add(id);
    }

    @Override
    public void forPaginate(StringBuilder sql, int pageNumber, int pageSize, String select) {
        throw new DbRecordException("Your should not invoke this method because takeOverDbPaginate(...) will take over it.");
    }

    @Override
    public boolean isTakeOverDbPaginate() {
        return true;
    }

    @Override
    public Page<Record> takeOverDbPaginate(Connection conn, int pageNumber, int pageSize, String select, boolean count, Object ... paras) throws SQLException {
        long totalRow = 0L;
        int totalPage = 0;
        if (count) {
            List result = Db.query(DbKit.getConfig(), conn, "select count(*) from (" + select + ") as _tmp", paras);
            int size = result.size();
            if (size == 1) {
                totalRow = ((Number)result.get(0)).longValue();
            } else if (size > 1) {
                totalRow = result.size();
            } else {
                return new Page<Record>(new ArrayList(0), pageNumber, pageSize, 0, 0);
            }
        }
        totalPage = (int)(totalRow / (long)pageSize);
        if (totalRow % (long)pageSize != 0L) {
            ++totalPage;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(select).append(" ");
        PreparedStatement pst = conn.prepareStatement(sql.toString(), 1003, 1007);
        for (int i = 0; i < paras.length; ++i) {
            pst.setObject(i + 1, paras[i]);
        }
        ResultSet rs = pst.executeQuery();
        int offset = pageSize * (pageNumber - 1);
        for (int i = 0; i < offset && rs.next(); ++i) {
        }
        List<Record> list = this.buildRecord(rs, pageSize);
        if (rs != null) {
            rs.close();
        }
        if (pst != null) {
            pst.close();
        }
        return new Page<Record>(list, pageNumber, pageSize, totalPage, (int)totalRow);
    }

    private List<Record> buildRecord(ResultSet rs, int pageSize) throws SQLException {
        ArrayList<Record> result = new ArrayList<Record>();
        ResultSetMetaData rsmd = rs.getMetaData();
        int columnCount = rsmd.getColumnCount();
        String[] labelNames = new String[columnCount + 1];
        int[] types = new int[columnCount + 1];
        this.buildLabelNamesAndTypes(rsmd, labelNames, types);
        for (int k = 0; k < pageSize && rs.next(); ++k) {
            Record record = new Record();
            Map<String, Object> columns = record.getColumns();
            for (int i = 1; i <= columnCount; ++i) {
                Object value = types[i] < 2004 ? rs.getObject(i) : (types[i] == 2005 ? RecordBuilder.handleClob(rs.getClob(i)) : (types[i] == 2011 ? RecordBuilder.handleClob(rs.getNClob(i)) : (types[i] == 2004 ? (Object)RecordBuilder.handleBlob(rs.getBlob(i)) : rs.getObject(i))));
                columns.put(labelNames[i], value);
            }
            result.add(record);
        }
        return result;
    }

    private void buildLabelNamesAndTypes(ResultSetMetaData rsmd, String[] labelNames, int[] types) throws SQLException {
        for (int i = 1; i < labelNames.length; ++i) {
            labelNames[i] = rsmd.getColumnLabel(i);
            types[i] = rsmd.getColumnType(i);
        }
    }

    @Override
    public boolean isTakeOverModelPaginate() {
        return true;
    }
}

