/*
 * Decompiled with CFR 0.152.
 */
package com.liucf.dbrecord.dialect;

import com.liucf.dbrecord.Page;
import com.liucf.dbrecord.Record;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public abstract class Dialect {
    public abstract String forTableBuilderDoBuild(String var1);

    public abstract String forDbFindById(String var1, String var2, String var3);

    public abstract String forDbDeleteById(String var1, String var2);

    public abstract void forDbSave(StringBuilder var1, List<Object> var2, String var3, Record var4);

    public abstract void forDbUpdate(String var1, String var2, Object var3, Record var4, StringBuilder var5, List<Object> var6);

    public abstract void forPaginate(StringBuilder var1, int var2, int var3, String var4);

    public boolean isOracle() {
        return false;
    }

    public boolean isTakeOverDbPaginate() {
        return false;
    }

    public Page<Record> takeOverDbPaginate(Connection conn, int pageNumber, int pageSize, String select, boolean count, Object ... paras) throws SQLException {
        throw new RuntimeException("You should implements this method in " + this.getClass().getName());
    }

    public boolean isTakeOverModelPaginate() {
        return false;
    }

    public void fillStatement(PreparedStatement pst, List<Object> paras) throws SQLException {
        int size = paras.size();
        for (int i = 0; i < size; ++i) {
            pst.setObject(i + 1, paras.get(i));
        }
    }

    public void fillStatement(PreparedStatement pst, Object ... paras) throws SQLException {
        for (int i = 0; i < paras.length; ++i) {
            pst.setObject(i + 1, paras[i]);
        }
    }

    public String getDefaultPrimaryKey() {
        return "id";
    }
}

