/*
 * Decompiled with CFR 0.152.
 */
package com.liucf.dbrecord.dialect;

import com.liucf.dbrecord.Record;
import com.liucf.dbrecord.dialect.Dialect;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;

public class OracleDialect
extends Dialect {
    @Override
    public String forTableBuilderDoBuild(String tableName) {
        return "select * from " + tableName + " where rownum < 1";
    }

    @Override
    public String forDbFindById(String tableName, String primaryKey, String columns) {
        StringBuilder sql = new StringBuilder("select ");
        if (columns.trim().equals("*")) {
            sql.append(columns);
        } else {
            String[] columnsArray = columns.split(",");
            for (int i = 0; i < columnsArray.length; ++i) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append(columnsArray[i].trim());
            }
        }
        sql.append(" from ");
        sql.append(tableName.trim());
        sql.append(" where ").append(primaryKey).append(" = ?");
        return sql.toString();
    }

    @Override
    public String forDbDeleteById(String tableName, String primaryKey) {
        StringBuilder sql = new StringBuilder("delete from ");
        sql.append(tableName.trim());
        sql.append(" where ").append(primaryKey).append(" = ?");
        return sql.toString();
    }

    @Override
    public void forDbSave(StringBuilder sql, List<Object> paras, String tableName, Record record) {
        sql.append("insert into ");
        sql.append(tableName.trim()).append("(");
        StringBuilder temp = new StringBuilder();
        temp.append(") values(");
        int count = 0;
        for (Map.Entry<String, Object> e : record.getColumns().entrySet()) {
            if (count++ > 0) {
                sql.append(", ");
                temp.append(", ");
            }
            sql.append(e.getKey());
            Object value = e.getValue();
            if (value instanceof String && ((String)value).endsWith(".nextval")) {
                temp.append(value);
                continue;
            }
            temp.append("?");
            paras.add(value);
        }
        sql.append(temp.toString()).append(")");
    }

    @Override
    public void forDbUpdate(String tableName, String primaryKey, Object id, Record record, StringBuilder sql, List<Object> paras) {
        sql.append("update ").append(tableName.trim()).append(" set ");
        for (Map.Entry<String, Object> e : record.getColumns().entrySet()) {
            String colName = e.getKey();
            if (primaryKey.equalsIgnoreCase(colName)) continue;
            if (paras.size() > 0) {
                sql.append(", ");
            }
            sql.append(colName).append(" = ? ");
            paras.add(e.getValue());
        }
        sql.append(" where ").append(primaryKey).append(" = ?");
        paras.add(id);
    }

    @Override
    public void forPaginate(StringBuilder sql, int pageNumber, int pageSize, String select) {
        int satrt = (pageNumber - 1) * pageSize + 1;
        int end = pageNumber * pageSize;
        sql.append("select * from ( select row_.*, rownum rownum_ from (  ");
        sql.append(select).append(" ");
        sql.append(" ) row_ where rownum <= ").append(end).append(") table_alias");
        sql.append(" where table_alias.rownum_ >= ").append(satrt);
    }

    @Override
    public boolean isOracle() {
        return true;
    }

    @Override
    public void fillStatement(PreparedStatement pst, List<Object> paras) throws SQLException {
        int size = paras.size();
        for (int i = 0; i < size; ++i) {
            Object value = paras.get(i);
            if (value instanceof Date) {
                pst.setDate(i + 1, (Date)value);
                continue;
            }
            pst.setObject(i + 1, value);
        }
    }

    @Override
    public void fillStatement(PreparedStatement pst, Object ... paras) throws SQLException {
        for (int i = 0; i < paras.length; ++i) {
            Object value = paras[i];
            if (value instanceof Date) {
                pst.setDate(i + 1, (Date)value);
                continue;
            }
            if (value instanceof Timestamp) {
                pst.setTimestamp(i + 1, (Timestamp)value);
                continue;
            }
            pst.setObject(i + 1, value);
        }
    }

    @Override
    public String getDefaultPrimaryKey() {
        return "ID";
    }
}

