/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.parser.deserializer;

import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.parser.JSONLexer;
import com.meidusa.fastjson.parser.ParserConfig;
import com.meidusa.fastjson.parser.deserializer.FieldDeserializer;
import com.meidusa.fastjson.parser.deserializer.ObjectDeserializer;
import com.meidusa.fastjson.util.FieldInfo;

public class StringFieldDeserializer
extends FieldDeserializer {
    private final ObjectDeserializer fieldValueDeserilizer;

    public StringFieldDeserializer(ParserConfig config, Class<?> clazz, FieldInfo fieldInfo) {
        super(clazz, fieldInfo);
        this.fieldValueDeserilizer = config.getDeserializer(fieldInfo);
    }

    @Override
    public void parseField(DefaultExtJSONParser parser, Object object) {
        String value;
        JSONLexer lexer = parser.getLexer();
        if (lexer.token() == 4) {
            value = lexer.stringVal();
            lexer.nextToken(16);
        } else {
            Object obj = parser.parse();
            value = obj == null ? null : obj.toString();
        }
        this.setValue(object, value);
    }

    @Override
    public int getFastMatchToken() {
        return this.fieldValueDeserilizer.getFastMatchToken();
    }
}

