/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.parser.deserializer;

import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.parser.DefaultExtJSONParser;
import com.meidusa.fastjson.parser.Feature;
import com.meidusa.fastjson.parser.JSONLexer;
import com.meidusa.fastjson.parser.JSONScanner;
import com.meidusa.fastjson.parser.JSONToken;
import com.meidusa.fastjson.parser.ParserConfig;
import com.meidusa.fastjson.parser.deserializer.ASMDeserializerFactory;
import com.meidusa.fastjson.parser.deserializer.ASMJavaBeanDeserializer;
import com.meidusa.fastjson.parser.deserializer.ObjectDeserializer;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashMap;

public class TypeHandleBeanSerializer
extends ASMJavaBeanDeserializer {
    private String key;
    private HashMap<String, Class<?>> valueClassMapping = new HashMap();
    private ObjectDeserializer defaultAsmJavaBeanDeserializer;
    private boolean isAbstract = false;

    public void addValueClass(String str, Class<?> clazz) {
        this.valueClassMapping.put(str, clazz);
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public HashMap<String, Class<?>> getValueClassMapping() {
        return this.valueClassMapping;
    }

    public void setValueClassMapping(HashMap<String, Class<?>> valueClassMapping) {
        this.valueClassMapping = valueClassMapping;
    }

    public TypeHandleBeanSerializer(ParserConfig mapping, Class<?> clazz) {
        super(mapping, clazz);
        if (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers())) {
            this.defaultAsmJavaBeanDeserializer = null;
            this.isAbstract = true;
        } else {
            try {
                this.defaultAsmJavaBeanDeserializer = ASMDeserializerFactory.getInstance().createJavaBeanDeserializer(mapping, clazz);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        mapping.putDeserializer(clazz, this);
    }

    @Override
    public Object createInstance(DefaultExtJSONParser parser, Type type) {
        return new Object();
    }

    @Override
    public <T> T deserialze(DefaultExtJSONParser parser, Type type) {
        Class<?> shouldBe;
        int j;
        char c;
        int i;
        JSONScanner jsonscanner;
        block9: {
            jsonscanner = (JSONScanner)parser.getLexer();
            i = jsonscanner.getBufferPosition();
            c = jsonscanner.getCurrent();
            j = jsonscanner.token();
            shouldBe = null;
            if (jsonscanner.token() == 8) {
                jsonscanner.nextToken(16);
                return null;
            }
            while (true) {
                String key;
                if ((key = jsonscanner.scanSymbol(parser.getSymbolTable())) == null) {
                    if (jsonscanner.token() == 13) {
                        jsonscanner.nextToken(16);
                        break block9;
                    }
                    if (jsonscanner.token() == 16 && parser.isEnabled(Feature.AllowArbitraryCommas)) continue;
                }
                jsonscanner.nextTokenWithColon();
                Object o = this.skipComplicatedVlue(parser, jsonscanner);
                if (o != null) {
                    String str = o.toString();
                    shouldBe = this.valueClassMapping.get(str);
                }
                if (shouldBe != null) break block9;
                if (jsonscanner.token() == 16) continue;
                if (jsonscanner.token() == 13) {
                    jsonscanner.nextToken(16);
                    break block9;
                }
                if (jsonscanner.token() == 18 || jsonscanner.token() == 1) break;
            }
            throw new JSONException("syntax error, unexpect token " + JSONToken.name(jsonscanner.token()));
        }
        jsonscanner.reset(i, c, j);
        if (shouldBe == null) {
            if (this.isAbstract) {
                throw new JSONException(String.valueOf(this.key) + "must be set");
            }
            if (this.defaultAsmJavaBeanDeserializer != null) {
                return this.defaultAsmJavaBeanDeserializer.deserialze(parser, type);
            }
            return super.deserialze(parser, type);
        }
        return parser.parseObject(shouldBe);
    }

    public Object skipComplicatedVlue(DefaultExtJSONParser parser, JSONLexer lexer) {
        switch (lexer.token()) {
            case 14: {
                int inner = 1;
                lexer.nextToken();
                while (true) {
                    if (lexer.token() == 14) {
                        ++inner;
                    } else if (lexer.token() == 15 && --inner == 0) break;
                    lexer.nextToken();
                }
                lexer.nextToken();
                return null;
            }
            case 12: {
                int inner = 1;
                lexer.nextToken();
                while (true) {
                    if (lexer.token() == 12) {
                        ++inner;
                    } else if (lexer.token() == 13 && --inner == 0) break;
                    lexer.nextToken();
                }
                lexer.nextToken();
                return null;
            }
            case 2: {
                Number intValue = lexer.integerValue();
                lexer.nextToken();
                return intValue;
            }
            case 3: {
                Number value = parser.isEnabled(Feature.UseBigDecimal) ? lexer.decimalValue() : Double.valueOf(lexer.doubleValue());
                lexer.nextToken();
                return value;
            }
            case 4: {
                JSONScanner iso8601Lexer;
                String stringLiteral = lexer.stringVal();
                lexer.nextToken(16);
                if (lexer.isEnabled(Feature.AllowISO8601DateFormat) && (iso8601Lexer = new JSONScanner(stringLiteral)).scanISO8601DateIfMatch()) {
                    return iso8601Lexer.getCalendar().getTime();
                }
                return stringLiteral;
            }
            case 8: {
                lexer.nextToken();
                return null;
            }
            case 6: {
                lexer.nextToken();
                return Boolean.TRUE;
            }
            case 7: {
                lexer.nextToken();
                return Boolean.FALSE;
            }
            case 9: {
                lexer.nextToken(16);
            }
            case 20: {
                if (!lexer.isBlankInput()) break;
                return null;
            }
        }
        throw new JSONException("TODO " + JSONToken.name(lexer.token()) + " " + lexer.stringVal());
    }
}

