/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.serializer;

import com.meidusa.fastjson.serializer.JSONSerializer;
import com.meidusa.fastjson.serializer.ObjectSerializer;
import com.meidusa.fastjson.serializer.SerializeWriter;
import com.meidusa.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class AtomicIntegerArraySerializer
implements ObjectSerializer {
    public static final AtomicIntegerArraySerializer instance = new AtomicIntegerArraySerializer();

    @Override
    public void write(JSONSerializer serializer, Object object) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (object == null) {
            if (out.isEnabled(SerializerFeature.WriteNullListAsEmpty)) {
                out.write("[]");
            } else {
                out.writeNull();
            }
            return;
        }
        AtomicIntegerArray array = (AtomicIntegerArray)object;
        int len = array.length();
        out.append('[');
        int i = 0;
        while (i < len) {
            int val = array.get(i);
            if (i != 0) {
                out.write(',');
            }
            out.writeInt(val);
            ++i;
        }
        out.append(']');
    }
}

