/*
 * Decompiled with CFR 0.152.
 */
package com.meidusa.fastjson.serializer;

import com.meidusa.fastjson.JSONException;
import com.meidusa.fastjson.util.ThreadLocalCache;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

public class SerialWriterStringEncoder {
    private final CharsetEncoder encoder;

    public SerialWriterStringEncoder(Charset cs) {
        this(cs.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE));
    }

    public SerialWriterStringEncoder(CharsetEncoder encoder) {
        this.encoder = encoder;
    }

    public byte[] encode(char[] chars, int off, int len) {
        if (len == 0) {
            return new byte[0];
        }
        this.encoder.reset();
        int bytesLength = SerialWriterStringEncoder.scale(len, this.encoder.maxBytesPerChar());
        byte[] bytes = ThreadLocalCache.getBytes(bytesLength);
        return this.encode(chars, off, len, bytes);
    }

    public CharsetEncoder getEncoder() {
        return this.encoder;
    }

    public byte[] encode(char[] chars, int off, int len, byte[] bytes) {
        ByteBuffer byteBuf = ByteBuffer.wrap(bytes);
        CharBuffer charBuf = CharBuffer.wrap(chars, off, len);
        try {
            CoderResult cr = this.encoder.encode(charBuf, byteBuf, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = this.encoder.flush(byteBuf)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new JSONException(x.getMessage(), x);
        }
        int bytesLength = byteBuf.position();
        byte[] copy = new byte[bytesLength];
        System.arraycopy(bytes, 0, copy, 0, bytesLength);
        return copy;
    }

    private static int scale(int len, float expansionFactor) {
        return (int)((double)len * (double)expansionFactor);
    }
}

