/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.discovery.plugin.strategy.configuration;

import com.nepxion.discovery.plugin.framework.adapter.PluginAdapter;
import com.nepxion.discovery.plugin.strategy.discovery.DiscoveryEnabledAdapter;
import com.nepxion.discovery.plugin.strategy.discovery.DiscoveryEnabledPredicate;
import com.nepxion.discovery.plugin.strategy.discovery.DiscoveryEnabledRule;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.netflix.ribbon.RibbonClientConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureBefore(value={RibbonClientConfiguration.class})
@ConditionalOnProperty(value={"spring.application.strategy.control.enabled"}, matchIfMissing=true)
public class StrategyAutoConfiguration {
    @Autowired
    protected PluginAdapter pluginAdapter;
    @Autowired
    private DiscoveryEnabledAdapter discoveryEnabledAdapter;

    @Bean
    @ConditionalOnMissingBean
    public DiscoveryEnabledRule discoveryEnabledRule() {
        DiscoveryEnabledRule discoveryEnabledRule = new DiscoveryEnabledRule();
        DiscoveryEnabledPredicate discoveryEnabledPredicate = discoveryEnabledRule.getDiscoveryEnabledPredicate();
        discoveryEnabledPredicate.setPluginAdapter(this.pluginAdapter);
        discoveryEnabledPredicate.setDiscoveryEnabledAdapter(this.discoveryEnabledAdapter);
        return discoveryEnabledRule;
    }
}

