/*
 * Decompiled with CFR 0.152.
 */
package com.nepxion.matrix.selector;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.context.EnvironmentAware;
import org.springframework.context.annotation.DeferredImportSelector;
import org.springframework.core.GenericTypeResolver;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;

public abstract class AbstractImportSelector<T>
implements DeferredImportSelector,
BeanClassLoaderAware,
EnvironmentAware {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractImportSelector.class);
    private ClassLoader beanClassLoader;
    private Class<T> annotationClass = GenericTypeResolver.resolveTypeArgument(this.getClass(), AbstractImportSelector.class);
    private Environment environment;

    protected AbstractImportSelector() {
    }

    public String[] selectImports(AnnotationMetadata metadata) {
        if (!this.isEnabled()) {
            return new String[0];
        }
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(this.annotationClass.getName(), true));
        Assert.notNull((Object)attributes, (String)("No " + this.getSimpleName() + " attributes found. Is " + metadata.getClassName() + " annotated with @" + this.getSimpleName() + "?"));
        ArrayList factories = new ArrayList(new LinkedHashSet(SpringFactoriesLoader.loadFactoryNames(this.annotationClass, (ClassLoader)this.beanClassLoader)));
        if (factories.isEmpty() && !this.hasDefaultFactory()) {
            throw new IllegalStateException("Annotation @" + this.getSimpleName() + " found, but there are no implementations. Did you forget to include a starter?");
        }
        if (factories.size() > 1) {
            LOG.warn("More than one implementation of @" + this.getSimpleName() + " (now relying on @Conditionals to pick one): " + factories);
        }
        return factories.toArray(new String[factories.size()]);
    }

    protected boolean hasDefaultFactory() {
        return false;
    }

    protected String getSimpleName() {
        return this.annotationClass.getSimpleName();
    }

    protected Class<T> getAnnotationClass() {
        return this.annotationClass;
    }

    protected Environment getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    protected abstract boolean isEnabled();

    static {
        System.out.println("");
        System.out.println("\u2554\u2550\u2557\u2554\u2550\u2557   \u2554\u2557");
        System.out.println("\u2551\u2551\u255a\u255d\u2551\u2551  \u2554\u255d\u255a\u2557");
        System.out.println("\u2551\u2554\u2557\u2554\u2557\u2560\u2550\u2550\u256c\u2557\u2554\u256c\u2550\u2566\u2566\u2557\u2554\u2557");
        System.out.println("\u2551\u2551\u2551\u2551\u2551\u2551\u2554\u2557\u2551\u2551\u2551\u2551\u2554\u256c\u256c\u256c\u256c\u255d");
        System.out.println("\u2551\u2551\u2551\u2551\u2551\u2551\u2554\u2557\u2551\u2551\u255a\u2563\u2551\u2551\u2560\u256c\u256c\u2557");
        System.out.println("\u255a\u255d\u255a\u255d\u255a\u2569\u255d\u255a\u255d\u255a\u2550\u2569\u255d\u255a\u2569\u255d\u255a\u255d");
        System.out.println("Nepxion Matrix - Import Selector  v2.0.1");
        System.out.println("");
    }
}

