/*
 * Decompiled with CFR 0.152.
 */
package com.netfinworks.ues.util;

import com.netfinworks.ues.UesDefine;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Collection;
import java.util.Enumeration;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.bouncycastle.cms.CMSEnvelopedData;
import org.bouncycastle.cms.CMSEnvelopedDataGenerator;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.RecipientInformation;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UesUtils {
    private static final Logger logger = LoggerFactory.getLogger(UesUtils.class);
    private static final String PKCS12 = "PKCS12";

    public static String getSerialNoFromCertification(X509Certificate cert) {
        return cert.getSerialNumber().toString(16);
    }

    public static String getSerialNoFromBase64Cert(String base64Cert) {
        X509Certificate cert = UesUtils.getX509CertFromBase64Cert(base64Cert);
        if (cert != null) {
            return cert.getSerialNumber().toString(16);
        }
        return null;
    }

    public static PublicKey getPublicKeyFromBase64Cert(String base64Cert) {
        X509Certificate cert = UesUtils.getX509CertFromBase64Cert(base64Cert);
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    public static X509Certificate getX509CertFromBase64Cert(String base64Cert) {
        if (base64Cert == null) {
            return null;
        }
        return UesUtils.getX509CertFromBytes(UesUtils.decodeBase64(base64Cert));
    }

    public static X509Certificate getX509CertFromBytes(byte[] byteArrayCert) {
        if (byteArrayCert == null) {
            return null;
        }
        return UesUtils.getX509CertFromInputStream(new ByteArrayInputStream(byteArrayCert));
    }

    public static X509Certificate getX509CertFromInputStream(InputStream streamCert) {
        X509Certificate cert = null;
        try {
            CertificateFactory factory = CertificateFactory.getInstance("X.509");
            cert = (X509Certificate)factory.generateCertificate(streamCert);
        }
        catch (CertificateException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return cert;
    }

    public static X509Certificate getX509CertFromPfxFile(String pfxFileName, String password) {
        if (pfxFileName == null || password == null) {
            return null;
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(pfxFileName);
            return UesUtils.getX509CertFromPfxInputStream(in, password);
        }
        catch (FileNotFoundException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static X509Certificate getX509CertFromPfxInputStream(InputStream in, String password) {
        try {
            KeyStore ks = KeyStore.getInstance(PKCS12);
            char[] passwd = password.toCharArray();
            ks.load(in, passwd);
            in.close();
            String alias = null;
            Enumeration<String> e = ks.aliases();
            if (e.hasMoreElements()) {
                alias = e.nextElement();
            }
            X509Certificate cert = (X509Certificate)ks.getCertificate(alias);
            return cert;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static PublicKey getPublicKeyFromBase64String(String base64PublicKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            X509EncodedKeySpec publicKeySpec = new X509EncodedKeySpec(UesUtils.decodeBase64(base64PublicKey));
            PublicKey publicKey = keyFactory.generatePublic(publicKeySpec);
            return publicKey;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static PublicKey getPublicKeyByPfxFile(String certPath, String password) {
        X509Certificate cert = UesUtils.getX509CertFromPfxFile(certPath, password);
        if (cert != null) {
            return cert.getPublicKey();
        }
        return null;
    }

    public static PrivateKey getPrivateKeyByPfxFile(String certPath, String password) {
        if (certPath == null || password == null) {
            return null;
        }
        try {
            FileInputStream in = null;
            in = new FileInputStream(certPath);
            return UesUtils.getPrivateKeyByInputStream(in, password);
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static PrivateKey getPrivateKeyByInputStream(InputStream in, String password) {
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance(PKCS12);
            ks.load(in, password.toCharArray());
            in.close();
            String alias = null;
            Enumeration<String> e = ks.aliases();
            while (e.hasMoreElements()) {
                alias = e.nextElement();
            }
            return (PrivateKey)ks.getKey(alias, password.toCharArray());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static PrivateKey getPrivateKeyFromBase64String(String base64PrivateKey) {
        try {
            byte[] privateKeyBytes = UesUtils.decodeBase64(base64PrivateKey);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
            KeyFactory keyFact = KeyFactory.getInstance("RSA");
            PrivateKey privateKey = keyFact.generatePrivate(keySpec);
            return privateKey;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static String encryptCMS(byte[] data, X509Certificate cert) {
        String algorithm = CMSEnvelopedDataGenerator.AES128_CBC;
        CMSEnvelopedDataGenerator fact = new CMSEnvelopedDataGenerator();
        fact.addKeyTransRecipient(cert);
        CMSProcessableByteArray content = new CMSProcessableByteArray(data);
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            CMSEnvelopedData envdata = fact.generate((CMSProcessable)content, algorithm, "BC");
            byte[] enveloped = envdata.getEncoded();
            return Base64.encodeBase64String((byte[])enveloped);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static byte[] decryptCMS(String base64EnvelopedData, FileInputStream pfxFile, String passwd) {
        PrivateKey key = UesUtils.getPrivateKeyByInputStream(pfxFile, passwd);
        X509Certificate cert = UesUtils.getX509CertFromPfxInputStream(pfxFile, passwd);
        return UesUtils.decryptCMS(base64EnvelopedData, cert, key);
    }

    public static byte[] decryptCMS(String base64EnvelopedData, X509Certificate cert, PrivateKey key) {
        byte[] envelopedData = null;
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            CMSEnvelopedData edata = new CMSEnvelopedData(UesUtils.decodeBase64(base64EnvelopedData));
            Collection cr = edata.getRecipientInfos().getRecipients();
            for (RecipientInformation ri : cr) {
                if (!ri.getRID().match((Certificate)cert)) continue;
                envelopedData = ri.getContent((Key)key, "BC");
                break;
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
        }
        return envelopedData;
    }

    public static String digest(String hashedSignContent, PrivateKey key, X509Certificate cert) {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            CMSSignedDataGenerator generator = new CMSSignedDataGenerator();
            generator.addSigner(key, cert, CMSSignedDataGenerator.DIGEST_SHA1);
            CMSProcessableByteArray content = new CMSProcessableByteArray(hashedSignContent.getBytes(UesDefine.DEFAULT_CHARSET));
            CMSSignedData signedData = generator.generate((CMSProcessable)content, true, "BC");
            return Base64.encodeBase64String((byte[])signedData.getEncoded());
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static boolean verifyDigest(String base64SignedData, X509Certificate cert) {
        try {
            boolean result = false;
            CMSSignedData sign = new CMSSignedData(UesUtils.decodeBase64(base64SignedData));
            Security.addProvider((Provider)new BouncyCastleProvider());
            SignerInformationStore signers = sign.getSignerInfos();
            Collection cc = signers.getSigners();
            for (SignerInformation signer : cc) {
                if (!signer.verify(cert.getPublicKey(), "BC")) continue;
                result = true;
            }
            return result;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    public static boolean verifyDigestWithOridata(String base64SignedData, X509Certificate cert, String oridata) {
        try {
            boolean result = false;
            CMSSignedData sign = new CMSSignedData(UesUtils.decodeBase64(base64SignedData));
            String oridataInSign = StringUtils.newStringUtf16Le((byte[])((byte[])sign.getSignedContent().getContent()));
            Security.addProvider((Provider)new BouncyCastleProvider());
            SignerInformationStore signers = sign.getSignerInfos();
            Collection cc = signers.getSigners();
            for (SignerInformation signer : cc) {
                if (!oridataInSign.equalsIgnoreCase(oridata) || !signer.verify(cert.getPublicKey(), "BC")) continue;
                result = true;
                break;
            }
            return result;
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    public static String bytesToHexString(byte[] src) {
        StringBuffer sb = new StringBuffer();
        if (src == null || src.length == 0) {
            return null;
        }
        int i = 0;
        while (i < src.length) {
            String hex = Integer.toHexString(src[i] & 0xFF);
            if (hex.length() == 1) {
                hex = String.valueOf('0') + hex;
            }
            sb.append(hex.toUpperCase());
            ++i;
        }
        return sb.toString();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.length() < 1) {
            return null;
        }
        byte[] result = new byte[hexString.length() / 2];
        int i = 0;
        while (i < hexString.length() / 2) {
            int high = Integer.parseInt(hexString.substring(i * 2, i * 2 + 1), 16);
            int low = Integer.parseInt(hexString.substring(i * 2 + 1, i * 2 + 2), 16);
            result[i] = (byte)(high * 16 + low);
            ++i;
        }
        return result;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static String hashSignContent(String txt) {
        try {
            return DigestUtils.sha256Hex((byte[])txt.getBytes(UesDefine.DEFAULT_CHARSET));
        }
        catch (UnsupportedEncodingException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static String encryptRSA(byte[] data, X509Certificate cert) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, cert.getPublicKey());
            byte[] encrypted = cipher.doFinal(data);
            return Base64.encodeBase64String((byte[])encrypted);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static String encryptRSA(byte[] data, PublicKey pubKey) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(1, pubKey);
            byte[] encrypted = cipher.doFinal(data);
            return Base64.encodeBase64String((byte[])encrypted);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static byte[] decryptRSA(String base64EnvelopedData, PrivateKey key) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            cipher.init(2, key);
            byte[] content = UesUtils.decodeBase64(base64EnvelopedData);
            return cipher.doFinal(content);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static String encryptDESede(String originalTxt, String keyTxt) {
        try {
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            SecretKeySpec skeySpec = new SecretKeySpec(keyTxt.getBytes(UesDefine.DEFAULT_CHARSET), "DESede");
            IvParameterSpec iv = new IvParameterSpec(new byte[]{50, 51, 52, 53, 54, 55, 56, 57});
            cipher.init(1, (Key)skeySpec, iv);
            byte[] originalBytes = originalTxt.getBytes(UesDefine.DEFAULT_CHARSET);
            byte[] encryptedBytes = cipher.doFinal(originalBytes);
            return UesUtils.bytesToHexString(encryptedBytes);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static String decryptDESede(String encryptedHexTxt, String keyTxt) {
        try {
            Cipher cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            SecretKeySpec skeySpec = new SecretKeySpec(keyTxt.getBytes(UesDefine.DEFAULT_CHARSET), "DESede");
            IvParameterSpec iv = new IvParameterSpec(new byte[]{50, 51, 52, 53, 54, 55, 56, 57});
            cipher.init(2, (Key)skeySpec, iv);
            byte[] encryptedBytes = UesUtils.hexStringToBytes(encryptedHexTxt);
            byte[] original = cipher.doFinal(encryptedBytes);
            return new String(original, UesDefine.DEFAULT_CHARSET);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static String encryptAES(String originalTxt, String keyTxt) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            SecretKeySpec skeySpec = new SecretKeySpec(keyTxt.getBytes(UesDefine.DEFAULT_CHARSET), "AES");
            cipher.init(1, skeySpec);
            byte[] originalBytes = originalTxt.getBytes(UesDefine.DEFAULT_CHARSET);
            byte[] encryptedBytes = cipher.doFinal(originalBytes);
            return UesUtils.bytesToHexString(encryptedBytes);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static String decryptAES(String encryptedHexTxt, String keyTxt) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            SecretKeySpec skeySpec = new SecretKeySpec(keyTxt.getBytes(UesDefine.DEFAULT_CHARSET), "AES");
            cipher.init(2, skeySpec);
            byte[] encryptedBytes = UesUtils.hexStringToBytes(encryptedHexTxt);
            byte[] original = cipher.doFinal(encryptedBytes);
            return new String(original);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            return null;
        }
    }

    public static String generateRandomKey(int length) {
        return RandomStringUtils.randomAlphanumeric((int)length);
    }

    public static byte[] decodeBase64(String base64String) {
        return Base64.decodeBase64((byte[])StringUtils.getBytesUtf8((String)base64String));
    }
}

