/*
 * Decompiled with CFR 0.152.
 */
package com.ofpay.gavin.comm.domain;

import com.ofpay.gavin.comm.exception.CodeMap;
import java.io.Serializable;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class Result<T>
implements Serializable {
    private static final long serialVersionUID = -3652685469819122564L;
    private boolean success;
    private String retCode;
    private String retMsg;
    private T data;

    public String getRetCode() {
        return this.retCode;
    }

    public void setRetCode(String retCode) {
        this.retCode = retCode;
        this.setRetMsg(CodeMap.getMsgbyCode(retCode));
    }

    public String getRetMsg() {
        return this.retMsg;
    }

    public void setRetMsg(String retMsg) {
        this.retMsg = retMsg;
    }

    public static <T> Result<T> success() {
        Result<T> r = new Result<T>();
        r.setSuccess(true);
        r.setRetCode(CodeMap.OK);
        return r;
    }

    public static <T> Result<T> fail() {
        Result<T> r = new Result<T>();
        r.setSuccess(false);
        r.setRetCode(CodeMap.FAIL);
        return r;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

