/*
 * Decompiled with CFR 0.152.
 */
package com.ofpay.rex.captcha;

import com.ofpay.rex.captcha.CaptchaConfig;
import com.ofpay.rex.captcha.DrawCaptcha;
import com.ofpay.rex.captcha.FillType;
import com.ofpay.rex.captcha.ICaptchaControl;
import com.ofpay.rex.captcha.RandomUtil;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaptchaControl
implements ICaptchaControl,
Serializable {
    private static Logger logger = LoggerFactory.getLogger(CaptchaControl.class);
    private static final long serialVersionUID = -8256676832538234674L;
    protected int errorNumber = 0;
    protected int refreshTextNumber = 0;
    protected String currentText = null;
    private long createTime = 0L;
    private int expSeconds = 60;

    protected String getText() {
        this.currentText = this.refreshTextNumber > 50 ? RandomUtil.getRandomCaptchaText(0) : RandomUtil.getRandomNumberText(0);
        ++this.refreshTextNumber;
        this.createTime = new Date().getTime();
        return this.currentText;
    }

    protected CaptchaConfig getCaptchaConfig(CaptchaConfig ccfg) {
        ccfg.setFillType(FillType.values()[RandomUtils.nextInt((int)FillType.values().length)]);
        ccfg.setbWaveImage(this.errorNumber > 2);
        ccfg.setConnectPercent(Math.max(10, this.refreshTextNumber / 3));
        ccfg.setMaxRotation(Math.max(15, this.refreshTextNumber / 2));
        return ccfg;
    }

    @Override
    public boolean checkCaptcha(String captchaText) {
        logger.debug("CurrentText={}, inputCaptchaText={}", (Object)this.currentText, (Object)captchaText);
        if (StringUtils.isEmpty((String)this.currentText)) {
            return false;
        }
        boolean bRet = this.currentText.equalsIgnoreCase(captchaText);
        if (bRet) {
            this.errorNumber = 0;
            this.refreshTextNumber = 0;
        } else {
            ++this.errorNumber;
        }
        return bRet;
    }

    @Override
    public void drawImage(DrawCaptcha dc, OutputStream os) {
        if (null == dc || null == os) {
            return;
        }
        dc.createImage(this.getText(), os, this.getCaptchaConfig(dc.getCaptchaConfig()));
    }

    @Override
    public boolean isTimeout() {
        Date currentDate = new Date();
        int interval = (int)((currentDate.getTime() - this.createTime) / 1000L);
        return interval > this.expSeconds;
    }

    @Override
    public void setExpSeconds(int expSeconds) {
        if (expSeconds > 0) {
            this.expSeconds = expSeconds;
        }
    }

    @Override
    public int getExpSeconds() {
        return this.expSeconds;
    }
}

